<?php
include('db_func/db_comn_func.php');
$dbobj = new common_db();
$cur_dt = date("m-d-y");

$qrys = "SELECT c.*, op.*, oi.*, p.productName, p.pCode
FROM customer AS c
JOIN odrproducts AS op ON op.oCustID =  c.id
JOIN orderitem AS oi ON oi.odrID = op.orderID
JOIN products AS p ON p.productID = oi.prdtID
JOIN prdtprice AS pp ON pp.productID = p.productID WHERE op.orderID = ".$_GET['oid']." GROUP BY oi.prdtID ORDER BY oi.oItemID";

if(isset($_GET['aptid']) && $_GET['aptid'] != ""){
	$apdArr = explode("AN", $_GET['aptid']);
	$apt_arr = $dbobj->get_cust_pet_apt_inf(end($apdArr));
}
$cst_arr = $dbobj->getQuery($qrys);

require('fpdf/html2pdf.php');
$pdf=new FPDF();
$pdf->AddPage();
$pdf->SetTitle("Invoice ".$cst_arr[0]['sr_name']." ".$cst_arr[0]['owner_name']);
$pdf->SetFont('Arial','B',12);

$pdf->Image("logo.png", 10, 10, 45, 35,"PNG");


$pdf->Cell(135,10,' ', 0, 0, "C");

$pdf->Cell(40,10,'', 0, 2, "C");


$pdf->SetFont('Arial','B',16);
$pdf->Cell(50,10,'INVOICE', 1, 1, "C");

$pdf->Cell(40,20,'', 0, 1);

// ADDRESS TABLE LINE 1
$pdf->SetFont('Arial','',11);
$pdf->Cell(135,5,'Bath n Biscuit', 0, 0, "L");

$pdf->SetFont('Arial','B',11);
$pdf->Cell(22,5,'Date:', 1, 0, "L");

$pdf->SetFont('Arial','',11);
$pdf->Cell(30,5, date('d/m/Y', strtotime($cst_arr[0]['oDate'])), 1, 1, "L");
// END LINE ONE


// ADDRESS TABLE LINE 2
$pdf->SetFont('Arial','',11);
$pdf->Cell(135,5,'K-3/104, DLF City II', 0, 0, "L");

$pdf->SetFont('Arial','B',11);
$pdf->Cell(22,5,'InvoiceNo:', 1, 0, "L");

$pdf->SetFont('Arial','',11);
$pdf->Cell(30,5,$cst_arr[0]['odrID'], 1, 1, "L");
// END LINE

// ADDRESS TABLE LINE 3
$pdf->SetFont('Arial','',11);
$pdf->Cell(135,5,'Gurgaon, Haryana, 122002.', 0, 0, "L");

$pdf->SetFont('Arial','B',11);
$pdf->Cell(22,5,'Cst. No.:', 1, 0, "L");

$pdf->SetFont('Arial','',11);
$pdf->Cell(30,5,$cst_arr[0]['custNo'], 1, 1, "L");
// END LINE


// ADDRESS TABLE LINE 4
$pdf->SetFont('Arial','',11);
$pdf->Cell(135,5,'Phone No :- 012-44017956', 0, 0, "L");

$pdf->SetFont('Arial','B',11);
if(isset($apt_arr)){
	$pdf->Cell(22,5,'Apt. No.', 1, 0, "L");
}
$pdf->SetFont('Arial','',11);
if(isset($apt_arr)){
	$pdf->Cell(30,5,$apt_arr[0]['aptNo'], 1, 1, "L");
}


// END LINE


// END OF COMPANY ADDRESS
// BILLING INFORMATION
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
$pdf->Cell(120,20,'', 0, 1);

$pdf->SetFont('Arial','B',12);
$pdf->Cell(135,10,'Bill To :', 0, 1, "L");

$pdf->SetFont('Arial','',11);
$pdf->Cell(135,5,$cst_arr[0]['sr_name']." ".$cst_arr[0]['owner_name'], 0, 1, "L");
$pdf->Cell(135,5,$cst_arr[0]['owner_address'], 0, 1, "L");
$pdf->Cell(50,5,'Contact:- '.$cst_arr[0]['cont_no'].'', 0, 1, "L");
$pdf->Cell(70,5,'Email:- '.$cst_arr[0]['email'].'', 0, 1, "L");

// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// TABLE CREATION
// Table Header
$pdf->Cell(120,15,'', 0, 1);
$pdf->SetFont('Arial','B',10);

$pdf->Cell(10,5,'S.NO.', 1, 0, "C");
$pdf->Cell(90,5,'PRODUCT NAME', 1, 0, "C");
$pdf->Cell(10,5,'QTY.', 1, 0, "C");
$pdf->Cell(17,5,'MRP', 1, 0, "L");
$pdf->Cell(18,5,'PRICE', 1, 0, "L");
$pdf->Cell(15,5,'LESS', 1, 0, "L");
$pdf->Cell(25,5,'TOTAL', 1, 1, "C");
// End Table Header

// Table Body
$pdf->SetFont('Arial','',10);
$ttlams = 0;
$ctr = 1;

foreach ($cst_arr as $key => $value) {
	$ctr = $ctr + $key;
	$sPrc = $value['currPrice'];
	$sMrp = $value['curMrp'];
	$rateDiff = $sPrc - $sMrp;
	$discPer = ($rateDiff/$sMrp)*100;

	$pdf->Cell(10,6, $ctr, 'L', 0, "C");
	$pdf->Cell(90,6, $value['productName'], 'L', 0, "L");
	$pdf->Cell(10,6, $value['prdtQty'], 'L', 0, "C");
	$pdf->Cell(17,6, $value['curMrp'], 'L', 0, "L");
	$pdf->Cell(18,6, $value['currPrice'], 'L', 0, "L");
	$pdf->Cell(15,6, number_format($discPer, 2, '.', '').'%', 'L', 0, "L");
	$pdf->Cell(25,6, number_format($value['prdtQty'] * $value['currPrice'], 2, '.', ''), 'LR', 1, "C");

	if($ttlams != 0){
		$ttlams = $ttlams + ($value['prdtQty'] * $value['currPrice']);
	}else{
		$ttlams = $value['prdtQty'] * $value['currPrice'];
	}
}
// End of product sale body

if(isset($apt_arr)){
	foreach ($apt_arr as $key => $value) {
		$ctr = $ctr + 1;
		$pdf->Cell(10,6, $ctr, 'L', 0, "C");
		$pdf->Cell(90,6, $value['apt_remarks'], 'L', 0, "L");
		$pdf->Cell(10,6, 1, 'L', 0, "C");
		$pdf->Cell(17,6, $value['aptAmt'], 'L', 0, "L");
		$pdf->Cell(18,6, $value['aptAmt'], 'L', 0, "L");
	
		if($value['taxSts'] == 1){
			$pdf->Cell(15,6,'+('.STAX.'%)', 'L', 0, "L");
			$aptamtax = ($value['aptAmt'] * STAX)/100;
			$aptamtax = $value['aptAmt']+$aptamtax;	
		}else{
			$aptamtax = $value['aptAmt'];
			$pdf->Cell(15,6,'+0.00%', 'L', 0, "L");
		}
		$pdf->Cell(25,6, number_format($aptamtax, 2, '.', ''), 'LR', 1, "C");	
	}
}
// End table Body

// Give the gaping in bottom table
$pdf->Cell(10,10,'', 'L', 0, "C");
$pdf->Cell(90,10,'', 'L', 0, "L");
$pdf->Cell(10,10,'', 'L', 0, "C");
$pdf->Cell(17,10,'', 'L', 0, "C");
$pdf->Cell(18,10,'', 'LR', 0, "C");
$pdf->Cell(15,10,'', 'R', 0, "C");
$pdf->Cell(25,10,'', 'R', 1, "C");
$pdf->SetFont('Arial','B',10);

$pdf->Cell(127,6,'', 'TLR', 0, "L");
$pdf->Cell(33,6,'SUBTOTAL', 'T', 0, "L");

if(isset($apt_arr)){
	$subttol = $ttlams + $aptamtax;
	$pdf->Cell(25,6,number_format($subttol, 2, '.', ''), 1, 1, "C");	
}else{
	$pdf->Cell(25,6,number_format($ttlams, 2, '.', ''), 1, 1, "C");	
}


$pdf->Cell(127,6,'', 'LR', 0, "L");

if($cst_arr[0]['odrTax'] == 1){
	$pdf->Cell(33,6,'S.TAX('.STAX.'%)', 0, 0, "L");
	$tax = (($ttlams*STAX)/100);
}else{
	$pdf->Cell(33,6,'S.TAX(NA)', 0, 0, "L");
	$tax = 0.00;
}
$pdf->Cell(25,6,number_format($tax, 2, '.', ''), 1, 1, "C");

$pdf->Cell(127,6,'', 'LBR', 0, "L");
$pdf->Cell(33,6,'GRAND TTL', 'B', 0, "L");

if(isset($apt_arr)){
	$pdf->Cell(25,6,number_format($ttlams +$tax+$aptamtax, 2, '.', ''), 1, 1, "C");	
}else{
	$pdf->Cell(25,6,number_format($ttlams +$tax, 2, '.', ''), 1, 1, "C");	
}

$pdf->Cell(185,20,'', 0, 1, "C");
$pdf->Cell(185,6,'Thank You', 0, 1, "C");
$pdf->Cell(185,6,'****', 0, 0, "C");

$pdf->Output();
?>