"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var webpack_loader_1 = require("./build-optimizer/webpack-loader");
exports.buildOptimizerLoader = webpack_loader_1.default;
var build_optimizer_1 = require("./build-optimizer/build-optimizer");
exports.buildOptimizer = build_optimizer_1.buildOptimizer;
var webpack_plugin_1 = require("./purify/webpack-plugin");
exports.PurifyPlugin = webpack_plugin_1.PurifyPlugin;
var purify_1 = require("./purify/purify");
exports.purify = purify_1.purify;
var transform_javascript_1 = require("./helpers/transform-javascript");
exports.transformJavascript = transform_javascript_1.transformJavascript;
var class_fold_1 = require("./transforms/class-fold");
exports.getFoldFileTransformer = class_fold_1.getFoldFileTransformer;
var import_tslib_1 = require("./transforms/import-tslib");
exports.getImportTslibTransformer = import_tslib_1.getImportTslibTransformer;
exports.testImportTslib = import_tslib_1.testImportTslib;
var prefix_classes_1 = require("./transforms/prefix-classes");
exports.getPrefixClassesTransformer = prefix_classes_1.getPrefixClassesTransformer;
exports.testPrefixClasses = prefix_classes_1.testPrefixClasses;
var prefix_functions_1 = require("./transforms/prefix-functions");
exports.getPrefixFunctionsTransformer = prefix_functions_1.getPrefixFunctionsTransformer;
var scrub_file_1 = require("./transforms/scrub-file");
exports.getScrubFileTransformer = scrub_file_1.getScrubFileTransformer;
exports.testScrubFile = scrub_file_1.testScrubFile;
var wrap_enums_1 = require("./transforms/wrap-enums");
exports.getWrapEnumsTransformer = wrap_enums_1.getWrapEnumsTransformer;
exports.testWrapEnums = wrap_enums_1.testWrapEnums;
//# sourceMappingURL=data:application/json;base64,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