#!/usr/bin/env node
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const purify_1 = require("./purify");
if (process.argv.length < 3 || process.argv.length > 4) {
    throw new Error(`
    purify should be called with either one or two arguments:

      purify input.js
      purify input.js output.js
  `);
}
const currentDir = process.cwd();
const inputFile = process.argv[2];
const tsOrJsRegExp = /\.(j|t)s$/;
if (!inputFile.match(tsOrJsRegExp)) {
    throw new Error(`Input file must be .js or .ts.`);
}
// Use provided output file, or add the .purify suffix before the extension.
const outputFile = process.argv[3]
    || inputFile.replace(tsOrJsRegExp, (subStr) => `.purify${subStr}`);
const purifyOutput = purify_1.purify(fs_1.readFileSync(path_1.join(currentDir, inputFile), 'UTF-8'));
fs_1.writeFileSync(path_1.join(currentDir, outputFile), purifyOutput);
console.log(`Emitted: ${outputFile}`);
//# sourceMappingURL=data:application/json;base64,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