var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Injectable } from '@angular/core';
import { CordovaInstance, InstanceCheck, IonicNativePlugin, Plugin, checkAvailability } from '@ionic-native/core';
/**
 * @name File Transfer
 *
 * @description
 * This plugin allows you to upload and download files.
 *
 * @deprecated
 * This plugin has been deprecated in favor of XHR2
 * https://cordova.apache.org/blog/2017/10/18/from-filetransfer-to-xhr2.html
 *
 * @usage
 * ```typescript
 * import { FileTransfer, FileUploadOptions, FileTransferObject } from '@ionic-native/file-transfer';
 * import { File } from '@ionic-native/file';
 *
 * constructor(private transfer: FileTransfer, private file: File) { }
 *
 * ...
 *
 * const fileTransfer: FileTransferObject = this.transfer.create();
 *
 * // Upload a file:
 * fileTransfer.upload(..).then(..).catch(..);
 *
 * // Download a file:
 * fileTransfer.download(..).then(..).catch(..);
 *
 * // Abort active transfer:
 * fileTransfer.abort();
 *
 * // full example
 * upload() {
 *   let options: FileUploadOptions = {
 *      fileKey: 'file',
 *      fileName: 'name.jpg',
 *      headers: {}
 *      .....
 *   }
 *
 *   fileTransfer.upload('<file path>', '<api endpoint>', options)
 *    .then((data) => {
 *      // success
 *    }, (err) => {
 *      // error
 *    })
 * }
 *
 * download() {
 *   const url = 'http://www.example.com/file.pdf';
 *   fileTransfer.download(url, this.file.dataDirectory + 'file.pdf').then((entry) => {
 *     console.log('download complete: ' + entry.toURL());
 *   }, (error) => {
 *     // handle error
 *   });
 * }
 *
 * ```
 *
 * To store files in a different/publicly accessible directory, please refer to the following link
 * https://github.com/apache/cordova-plugin-file#where-to-store-files
 *
 * @interfaces
 * FileUploadOptions
 * FileUploadResult
 * FileTransferError
 * @classes
 * FileTransferObject
 */
var FileTransfer = (function (_super) {
    __extends(FileTransfer, _super);
    function FileTransfer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
           * Error code rejected from upload with FileTransferError
           * Defined in FileTransferError.
           *      FILE_NOT_FOUND_ERR: 1   Return when file was not found
           *      INVALID_URL_ERR: 2,     Return when url was invalid
           *      CONNECTION_ERR: 3,      Return on connection error
           *      ABORT_ERR: 4,           Return on aborting
           *      NOT_MODIFIED_ERR: 5     Return on '304 Not Modified' HTTP response
           * @enum {number}
           */
        _this.FileTransferErrorCode = {
            FILE_NOT_FOUND_ERR: 1,
            INVALID_URL_ERR: 2,
            CONNECTION_ERR: 3,
            ABORT_ERR: 4,
            NOT_MODIFIED_ERR: 5
        };
        return _this;
    }
    /**
     * Creates a new FileTransfer object
     * @return {FileTransferObject}
     */
    /**
       * Creates a new FileTransfer object
       * @return {FileTransferObject}
       */
    FileTransfer.prototype.create = /**
       * Creates a new FileTransfer object
       * @return {FileTransferObject}
       */
    function () {
        return new FileTransferObject();
    };
    FileTransfer.decorators = [
        { type: Injectable },
    ];
    /**
     * @name File Transfer
     *
     * @description
     * This plugin allows you to upload and download files.
     *
     * @deprecated
     * This plugin has been deprecated in favor of XHR2
     * https://cordova.apache.org/blog/2017/10/18/from-filetransfer-to-xhr2.html
     *
     * @usage
     * ```typescript
     * import { FileTransfer, FileUploadOptions, FileTransferObject } from '@ionic-native/file-transfer';
     * import { File } from '@ionic-native/file';
     *
     * constructor(private transfer: FileTransfer, private file: File) { }
     *
     * ...
     *
     * const fileTransfer: FileTransferObject = this.transfer.create();
     *
     * // Upload a file:
     * fileTransfer.upload(..).then(..).catch(..);
     *
     * // Download a file:
     * fileTransfer.download(..).then(..).catch(..);
     *
     * // Abort active transfer:
     * fileTransfer.abort();
     *
     * // full example
     * upload() {
     *   let options: FileUploadOptions = {
     *      fileKey: 'file',
     *      fileName: 'name.jpg',
     *      headers: {}
     *      .....
     *   }
     *
     *   fileTransfer.upload('<file path>', '<api endpoint>', options)
     *    .then((data) => {
     *      // success
     *    }, (err) => {
     *      // error
     *    })
     * }
     *
     * download() {
     *   const url = 'http://www.example.com/file.pdf';
     *   fileTransfer.download(url, this.file.dataDirectory + 'file.pdf').then((entry) => {
     *     console.log('download complete: ' + entry.toURL());
     *   }, (error) => {
     *     // handle error
     *   });
     * }
     *
     * ```
     *
     * To store files in a different/publicly accessible directory, please refer to the following link
     * https://github.com/apache/cordova-plugin-file#where-to-store-files
     *
     * @interfaces
     * FileUploadOptions
     * FileUploadResult
     * FileTransferError
     * @classes
     * FileTransferObject
     */
    FileTransfer = __decorate([
        Plugin({
            pluginName: 'FileTransfer',
            plugin: 'cordova-plugin-file-transfer',
            pluginRef: 'FileTransfer',
            repo: 'https://github.com/apache/cordova-plugin-file-transfer',
            platforms: [
                'Amazon Fire OS',
                'Android',
                'Browser',
                'iOS',
                'Ubuntu',
                'Windows',
                'Windows Phone'
            ]
        })
    ], FileTransfer);
    return FileTransfer;
}(IonicNativePlugin));
export { FileTransfer };
/**
 * @hidden
 */
var FileTransferObject = (function () {
    function FileTransferObject() {
        if (checkAvailability(FileTransfer.getPluginRef(), null, FileTransfer.getPluginName()) === true) {
            this._objectInstance = new (FileTransfer.getPlugin())();
        }
    }
    /**
     * Sends a file to a server.
     *
     * @param {string} fileUrl  Filesystem URL representing the file on the device or a data URI. For backwards compatibility, this can also be the full path of the file on the device.
     * @param {string} url  URL of the server to receive the file, as encoded by encodeURI().
     * @param {FileUploadOptions} [options]  Optional parameters.
     * @param {boolean} [trustAllHosts]  Optional parameter, defaults to false. If set to true, it accepts all security certificates. This is useful since Android rejects self-signed security certificates. Not recommended for production use. Supported on Android and iOS.
     * @returns {Promise<FileUploadResult>} Returns a Promise that resolves to a FileUploadResult and rejects with FileTransferError.
     */
    /**
       * Sends a file to a server.
       *
       * @param {string} fileUrl  Filesystem URL representing the file on the device or a data URI. For backwards compatibility, this can also be the full path of the file on the device.
       * @param {string} url  URL of the server to receive the file, as encoded by encodeURI().
       * @param {FileUploadOptions} [options]  Optional parameters.
       * @param {boolean} [trustAllHosts]  Optional parameter, defaults to false. If set to true, it accepts all security certificates. This is useful since Android rejects self-signed security certificates. Not recommended for production use. Supported on Android and iOS.
       * @returns {Promise<FileUploadResult>} Returns a Promise that resolves to a FileUploadResult and rejects with FileTransferError.
       */
    FileTransferObject.prototype.upload = /**
       * Sends a file to a server.
       *
       * @param {string} fileUrl  Filesystem URL representing the file on the device or a data URI. For backwards compatibility, this can also be the full path of the file on the device.
       * @param {string} url  URL of the server to receive the file, as encoded by encodeURI().
       * @param {FileUploadOptions} [options]  Optional parameters.
       * @param {boolean} [trustAllHosts]  Optional parameter, defaults to false. If set to true, it accepts all security certificates. This is useful since Android rejects self-signed security certificates. Not recommended for production use. Supported on Android and iOS.
       * @returns {Promise<FileUploadResult>} Returns a Promise that resolves to a FileUploadResult and rejects with FileTransferError.
       */
    function (fileUrl, url, options, trustAllHosts) {
        return;
    };
    /**
     * Downloads a file from server.
     *
     * @param {string} source  URL of the server to download the file, as encoded by encodeURI().
     * @param {string} target  Filesystem url representing the file on the device. For backwards compatibility, this can also be the full path of the file on the device.
     * @param {boolean} [trustAllHosts]  Optional parameter, defaults to false. If set to true, it accepts all security certificates. This is useful because Android rejects self-signed security certificates. Not recommended for production use. Supported on Android and iOS.
     * @param {object} [Optional] parameters, currently only supports headers (such as Authorization (Basic Authentication), etc).
     * @returns {Promise<any>} Returns a Promise that resolves to a FileEntry object.
     */
    /**
       * Downloads a file from server.
       *
       * @param {string} source  URL of the server to download the file, as encoded by encodeURI().
       * @param {string} target  Filesystem url representing the file on the device. For backwards compatibility, this can also be the full path of the file on the device.
       * @param {boolean} [trustAllHosts]  Optional parameter, defaults to false. If set to true, it accepts all security certificates. This is useful because Android rejects self-signed security certificates. Not recommended for production use. Supported on Android and iOS.
       * @param {object} [Optional] parameters, currently only supports headers (such as Authorization (Basic Authentication), etc).
       * @returns {Promise<any>} Returns a Promise that resolves to a FileEntry object.
       */
    FileTransferObject.prototype.download = /**
       * Downloads a file from server.
       *
       * @param {string} source  URL of the server to download the file, as encoded by encodeURI().
       * @param {string} target  Filesystem url representing the file on the device. For backwards compatibility, this can also be the full path of the file on the device.
       * @param {boolean} [trustAllHosts]  Optional parameter, defaults to false. If set to true, it accepts all security certificates. This is useful because Android rejects self-signed security certificates. Not recommended for production use. Supported on Android and iOS.
       * @param {object} [Optional] parameters, currently only supports headers (such as Authorization (Basic Authentication), etc).
       * @returns {Promise<any>} Returns a Promise that resolves to a FileEntry object.
       */
    function (source, target, trustAllHosts, options) {
        return;
    };
    /**
     * Registers a listener that gets called whenever a new chunk of data is transferred.
     * @param {Function} listener Listener that takes a progress event.
     */
    /**
       * Registers a listener that gets called whenever a new chunk of data is transferred.
       * @param {Function} listener Listener that takes a progress event.
       */
    FileTransferObject.prototype.onProgress = /**
       * Registers a listener that gets called whenever a new chunk of data is transferred.
       * @param {Function} listener Listener that takes a progress event.
       */
    function (listener) {
        this._objectInstance.onprogress = listener;
    };
    /**
     * Aborts an in-progress transfer. The onerror callback is passed a FileTransferError
     * object which has an error code of FileTransferError.ABORT_ERR.
     */
    /**
       * Aborts an in-progress transfer. The onerror callback is passed a FileTransferError
       * object which has an error code of FileTransferError.ABORT_ERR.
       */
    FileTransferObject.prototype.abort = /**
       * Aborts an in-progress transfer. The onerror callback is passed a FileTransferError
       * object which has an error code of FileTransferError.ABORT_ERR.
       */
    function () { };
    __decorate([
        CordovaInstance({
            successIndex: 2,
            errorIndex: 3
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String, Object, Boolean]),
        __metadata("design:returntype", Promise)
    ], FileTransferObject.prototype, "upload", null);
    __decorate([
        CordovaInstance({
            successIndex: 2,
            errorIndex: 3
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, String, Boolean, Object]),
        __metadata("design:returntype", Promise)
    ], FileTransferObject.prototype, "download", null);
    __decorate([
        InstanceCheck({ sync: true }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", void 0)
    ], FileTransferObject.prototype, "onProgress", null);
    __decorate([
        CordovaInstance({
            sync: true
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], FileTransferObject.prototype, "abort", null);
    /**
     * @hidden
     */
    FileTransferObject = __decorate([
        Plugin({
            plugin: 'cordova-plugin-file-transfer',
            pluginName: 'FileTransfer'
        }),
        __metadata("design:paramtypes", [])
    ], FileTransferObject);
    return FileTransferObject;
}());
export { FileTransferObject };
//# sourceMappingURL=index.js.map