var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { Injectable } from '@angular/core';
import { Cordova, CordovaCheck, CordovaInstance, InstanceProperty, IonicNativePlugin, Plugin } from '@ionic-native/core';
/**
 * @hidden
 */
var SQLiteObject = (function () {
    function SQLiteObject(_objectInstance) {
        this._objectInstance = _objectInstance;
    }
    SQLiteObject.prototype.addTransaction = function (transaction) { };
    /**
     * @param fn {Function}
     * @returns {Promise<any>}
     */
    /**
       * @param fn {Function}
       * @returns {Promise<any>}
       */
    SQLiteObject.prototype.transaction = /**
       * @param fn {Function}
       * @returns {Promise<any>}
       */
    function (fn) {
        return;
    };
    /**
     * @param fn {Function}
     * @returns {Promise<any>}
     */
    /**
       * @param fn {Function}
       * @returns {Promise<any>}
       */
    SQLiteObject.prototype.readTransaction = /**
       * @param fn {Function}
       * @returns {Promise<any>}
       */
    function (fn) {
        return;
    };
    SQLiteObject.prototype.startNextTransaction = function () { };
    /**
     * @returns {Promise<any>}
     */
    /**
       * @returns {Promise<any>}
       */
    SQLiteObject.prototype.open = /**
       * @returns {Promise<any>}
       */
    function () {
        return;
    };
    /**
     * @returns {Promise<any>}
     */
    /**
       * @returns {Promise<any>}
       */
    SQLiteObject.prototype.close = /**
       * @returns {Promise<any>}
       */
    function () {
        return;
    };
    /**
     * Execute SQL on the opened database. Note, you must call `create` first, and
     * ensure it resolved and successfully opened the database.
     */
    /**
       * Execute SQL on the opened database. Note, you must call `create` first, and
       * ensure it resolved and successfully opened the database.
       */
    SQLiteObject.prototype.executeSql = /**
       * Execute SQL on the opened database. Note, you must call `create` first, and
       * ensure it resolved and successfully opened the database.
       */
    function (statement, params) {
        return;
    };
    /**
     * @param sqlStatements {Array<string | string[] | any>}
     * @returns {Promise<any>}
     */
    /**
       * @param sqlStatements {Array<string | string[] | any>}
       * @returns {Promise<any>}
       */
    SQLiteObject.prototype.sqlBatch = /**
       * @param sqlStatements {Array<string | string[] | any>}
       * @returns {Promise<any>}
       */
    function (sqlStatements) {
        return;
    };
    SQLiteObject.prototype.abortallPendingTransactions = function () { };
    __decorate([
        InstanceProperty,
        __metadata("design:type", Object)
    ], SQLiteObject.prototype, "databaseFeatures", void 0);
    __decorate([
        InstanceProperty,
        __metadata("design:type", Object)
    ], SQLiteObject.prototype, "openDBs", void 0);
    __decorate([
        CordovaInstance({
            sync: true
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", void 0)
    ], SQLiteObject.prototype, "addTransaction", null);
    __decorate([
        CordovaInstance({
            successIndex: 2,
            errorIndex: 1
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
    ], SQLiteObject.prototype, "transaction", null);
    __decorate([
        CordovaInstance(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function]),
        __metadata("design:returntype", Promise)
    ], SQLiteObject.prototype, "readTransaction", null);
    __decorate([
        CordovaInstance({
            sync: true
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], SQLiteObject.prototype, "startNextTransaction", null);
    __decorate([
        CordovaInstance(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], SQLiteObject.prototype, "open", null);
    __decorate([
        CordovaInstance(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], SQLiteObject.prototype, "close", null);
    __decorate([
        CordovaInstance(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [String, Array]),
        __metadata("design:returntype", Promise)
    ], SQLiteObject.prototype, "executeSql", null);
    __decorate([
        CordovaInstance(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Array]),
        __metadata("design:returntype", Promise)
    ], SQLiteObject.prototype, "sqlBatch", null);
    __decorate([
        CordovaInstance({
            sync: true
        }),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", void 0)
    ], SQLiteObject.prototype, "abortallPendingTransactions", null);
    return SQLiteObject;
}());
export { SQLiteObject };
/**
 * @name SQLite
 *
 * @description
 * Access SQLite databases on the device.
 *
 * @usage
 *
 * ```typescript
 * import { SQLite, SQLiteObject } from '@ionic-native/sqlite';
 *
 * constructor(private sqlite: SQLite) { }
 *
 * ...
 *
 * this.sqlite.create({
 *   name: 'data.db',
 *   location: 'default'
 * })
 *   .then((db: SQLiteObject) => {
 *
 *
 *     db.executeSql('create table danceMoves(name VARCHAR(32))', [])
 *       .then(() => console.log('Executed SQL'))
 *       .catch(e => console.log(e));
 *
 *
 *   })
 *   .catch(e => console.log(e));
 *
 * ```
 *
 * @classes
 * SQLiteObject
 * @interfaces
 * SQLiteDatabaseConfig
 * SQLiteTransaction
 */
var SQLite = (function (_super) {
    __extends(SQLite, _super);
    function SQLite() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Open or create a SQLite database file.
     *
     * See the plugin docs for an explanation of all options: https://github.com/litehelpers/Cordova-sqlite-storage#opening-a-database
     *
     * @param config {SQLiteDatabaseConfig} database configuration
     * @return Promise<SQLiteObject>
     */
    /**
       * Open or create a SQLite database file.
       *
       * See the plugin docs for an explanation of all options: https://github.com/litehelpers/Cordova-sqlite-storage#opening-a-database
       *
       * @param config {SQLiteDatabaseConfig} database configuration
       * @return Promise<SQLiteObject>
       */
    SQLite.prototype.create = /**
       * Open or create a SQLite database file.
       *
       * See the plugin docs for an explanation of all options: https://github.com/litehelpers/Cordova-sqlite-storage#opening-a-database
       *
       * @param config {SQLiteDatabaseConfig} database configuration
       * @return Promise<SQLiteObject>
       */
    function (config) {
        return new Promise(function (resolve, reject) {
            sqlitePlugin.openDatabase(config, function (db) { return resolve(new SQLiteObject(db)); }, reject);
        });
    };
    /**
     * Verify that both the Javascript and native part of this plugin are installed in your application
     * @returns {Promise<any>}
     */
    /**
       * Verify that both the Javascript and native part of this plugin are installed in your application
       * @returns {Promise<any>}
       */
    SQLite.prototype.echoTest = /**
       * Verify that both the Javascript and native part of this plugin are installed in your application
       * @returns {Promise<any>}
       */
    function () {
        return;
    };
    /**
     * Automatically verify basic database access operations including opening a database
     * @returns {Promise<any>}
     */
    /**
       * Automatically verify basic database access operations including opening a database
       * @returns {Promise<any>}
       */
    SQLite.prototype.selfTest = /**
       * Automatically verify basic database access operations including opening a database
       * @returns {Promise<any>}
       */
    function () {
        return;
    };
    /**
     * Deletes a database
     * @param config {SQLiteDatabaseConfig} database configuration
     * @returns {Promise<any>}
     */
    /**
       * Deletes a database
       * @param config {SQLiteDatabaseConfig} database configuration
       * @returns {Promise<any>}
       */
    SQLite.prototype.deleteDatabase = /**
       * Deletes a database
       * @param config {SQLiteDatabaseConfig} database configuration
       * @returns {Promise<any>}
       */
    function (config) {
        return;
    };
    SQLite.decorators = [
        { type: Injectable },
    ];
    __decorate([
        CordovaCheck(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], SQLite.prototype, "create", null);
    __decorate([
        Cordova(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], SQLite.prototype, "echoTest", null);
    __decorate([
        Cordova(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], SQLite.prototype, "selfTest", null);
    __decorate([
        Cordova(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Object]),
        __metadata("design:returntype", Promise)
    ], SQLite.prototype, "deleteDatabase", null);
    /**
     * @name SQLite
     *
     * @description
     * Access SQLite databases on the device.
     *
     * @usage
     *
     * ```typescript
     * import { SQLite, SQLiteObject } from '@ionic-native/sqlite';
     *
     * constructor(private sqlite: SQLite) { }
     *
     * ...
     *
     * this.sqlite.create({
     *   name: 'data.db',
     *   location: 'default'
     * })
     *   .then((db: SQLiteObject) => {
     *
     *
     *     db.executeSql('create table danceMoves(name VARCHAR(32))', [])
     *       .then(() => console.log('Executed SQL'))
     *       .catch(e => console.log(e));
     *
     *
     *   })
     *   .catch(e => console.log(e));
     *
     * ```
     *
     * @classes
     * SQLiteObject
     * @interfaces
     * SQLiteDatabaseConfig
     * SQLiteTransaction
     */
    SQLite = __decorate([
        Plugin({
            pluginName: 'SQLite',
            pluginRef: 'sqlitePlugin',
            plugin: 'cordova-sqlite-storage',
            repo: 'https://github.com/litehelpers/Cordova-sqlite-storage',
            platforms: ['Android', 'iOS', 'macOS', 'Windows']
        })
    ], SQLite);
    return SQLite;
}(IonicNativePlugin));
export { SQLite };
//# sourceMappingURL=index.js.map