import { EventEmitter } from '@angular/core';
import { FileLikeObject } from './file-like-object.class';
import { FileItem } from './file-item.class';
export interface Headers {
    name: string;
    value: string;
}
export declare type ParsedResponseHeaders = {
    [headerFieldName: string]: string;
};
export declare type FilterFunction = {
    name: string;
    fn: (item?: FileLikeObject, options?: FileUploaderOptions) => boolean;
};
export interface FileUploaderOptions {
    allowedMimeType?: string[];
    allowedFileType?: string[];
    autoUpload?: boolean;
    isHTML5?: boolean;
    filters?: FilterFunction[];
    headers?: Headers[];
    method?: string;
    authToken?: string;
    maxFileSize?: number;
    queueLimit?: number;
    removeAfterUpload?: boolean;
    url?: string;
    disableMultipart?: boolean;
    itemAlias?: string;
    authTokenHeader?: string;
    additionalParameter?: {
        [key: string]: any;
    };
    parametersBeforeFiles?: boolean;
    formatDataFunction?: Function;
    formatDataFunctionIsAsync?: boolean;
}
export declare class FileUploader {
    authToken: string;
    isUploading: boolean;
    queue: FileItem[];
    progress: number;
    _nextIndex: number;
    autoUpload: any;
    authTokenHeader: string;
    response: EventEmitter<any>;
    options: FileUploaderOptions;
    protected _failFilterIndex: number;
    constructor(options: FileUploaderOptions);
    setOptions(options: FileUploaderOptions): void;
    addToQueue(files: File[], options?: FileUploaderOptions, filters?: FilterFunction[] | string): void;
    removeFromQueue(value: FileItem): void;
    clearQueue(): void;
    uploadItem(value: FileItem): void;
    cancelItem(value: FileItem): void;
    uploadAll(): void;
    cancelAll(): void;
    isFile(value: any): boolean;
    isFileLikeObject(value: any): boolean;
    getIndexOfItem(value: any): number;
    getNotUploadedItems(): any[];
    getReadyItems(): any[];
    destroy(): void;
    onAfterAddingAll(fileItems: any): any;
    onBuildItemForm(fileItem: FileItem, form: any): any;
    onAfterAddingFile(fileItem: FileItem): any;
    onWhenAddingFileFailed(item: FileLikeObject, filter: any, options: any): any;
    onBeforeUploadItem(fileItem: FileItem): any;
    onProgressItem(fileItem: FileItem, progress: any): any;
    onProgressAll(progress: any): any;
    onSuccessItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): any;
    onErrorItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): any;
    onCancelItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): any;
    onCompleteItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): any;
    onCompleteAll(): any;
    _mimeTypeFilter(item: FileLikeObject): boolean;
    _fileSizeFilter(item: FileLikeObject): boolean;
    _fileTypeFilter(item: FileLikeObject): boolean;
    _onErrorItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): void;
    _onCompleteItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): void;
    protected _headersGetter(parsedHeaders: ParsedResponseHeaders): any;
    protected _xhrTransport(item: FileItem): any;
    protected _getTotalProgress(value?: number): number;
    protected _getFilters(filters: FilterFunction[] | string): FilterFunction[];
    protected _render(): any;
    protected _queueLimitFilter(): boolean;
    protected _isValidFile(file: FileLikeObject, filters: FilterFunction[], options: FileUploaderOptions): boolean;
    protected _isSuccessCode(status: number): boolean;
    protected _transformResponse(response: string, headers: ParsedResponseHeaders): string;
    protected _parseHeaders(headers: string): ParsedResponseHeaders;
    protected _onWhenAddingFileFailed(item: FileLikeObject, filter: any, options: any): void;
    protected _onAfterAddingFile(item: FileItem): void;
    protected _onAfterAddingAll(items: any): void;
    protected _onBeforeUploadItem(item: FileItem): void;
    protected _onBuildItemForm(item: FileItem, form: any): void;
    protected _onProgressItem(item: FileItem, progress: any): void;
    protected _onSuccessItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): void;
    protected _onCancelItem(item: FileItem, response: string, status: number, headers: ParsedResponseHeaders): void;
}
