"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var Lint = require("tslint");
var RULE_NAME = 'ter-arrow-spacing';
var Rule = (function (_super) {
    tslib_1.__extends(Rule, _super);
    function Rule() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Rule.prototype.apply = function (sourceFile) {
        var walker = new RuleWalker(sourceFile, this.getOptions());
        return this.applyWithWalker(walker);
    };
    return Rule;
}(Lint.Rules.AbstractRule));
Rule.metadata = {
    ruleName: RULE_NAME,
    description: 'require space before/after arrow function\'s arrow',
    rationale: (_a = ["\n      This rule normalizes the style of spacing before/after an arrow function\u2019s arrow(`=>`).\n      "], _a.raw = ["\n      This rule normalizes the style of spacing before/after an arrow function\u2019s arrow(\\`=>\\`).\n      "], Lint.Utils.dedent(_a)),
    optionsDescription: (_b = ["\n      This rule takes an object argument with `before` and `after` properties, each with a\n      Boolean value.\n\n      The default configuration is `{ \"before\": true, \"after\": true }`.\n\n      `true` means there should be one or more spaces and `false` means no spaces.\n      "], _b.raw = ["\n      This rule takes an object argument with \\`before\\` and \\`after\\` properties, each with a\n      Boolean value.\n\n      The default configuration is \\`{ \"before\": true, \"after\": true }\\`.\n\n      \\`true\\` means there should be one or more spaces and \\`false\\` means no spaces.\n      "], Lint.Utils.dedent(_b)),
    options: {
        type: 'array',
        items: [{
                type: 'object',
                properties: {
                    before: {
                        type: 'boolean'
                    },
                    after: {
                        type: 'boolean'
                    }
                },
                additionalProperties: false
            }],
        maxLength: 1
    },
    optionExamples: [
        (_c = ["\n        \"", "\": [true]\n        "], _c.raw = ["\n        \"", "\": [true]\n        "], Lint.Utils.dedent(_c, RULE_NAME)),
        (_d = ["\n        \"", "\": [true, {\n          \"before\": false,\n          \"after\": false\n        }]\n        "], _d.raw = ["\n        \"", "\": [true, {\n          \"before\": false,\n          \"after\": false\n        }]\n        "], Lint.Utils.dedent(_d, RULE_NAME))
    ],
    typescriptOnly: false,
    type: 'style'
};
exports.Rule = Rule;
var RuleWalker = (function (_super) {
    tslib_1.__extends(RuleWalker, _super);
    function RuleWalker(sourceFile, options) {
        var _this = _super.call(this, sourceFile, options) || this;
        _this.before = true;
        _this.after = true;
        var opt = _this.getOptions();
        if (opt[0]) {
            _this.before = opt[0].before !== false;
            _this.after = opt[0].after !== false;
        }
        _this.srcFile = sourceFile;
        _this.srcText = sourceFile.getFullText();
        return _this;
    }
    RuleWalker.prototype.visitArrowFunction = function (node) {
        var arrow = node.equalsGreaterThanToken;
        var arrowStart = arrow.getStart(this.srcFile);
        var bodyStart = node.body.getStart(this.srcFile);
        var space = {
            before: /\s/.test(this.srcText[arrowStart - 1]),
            after: /\s/.test(this.srcText[arrow.end])
        };
        if (this.before) {
            if (!space.before) {
                var fix = Lint.Replacement.appendText(arrowStart, ' ');
                this.report(arrow, 'Missing', 'before', fix);
            }
        }
        else {
            if (space.before) {
                var spaces = arrowStart - arrow.getFullStart();
                var fix = Lint.Replacement.deleteText(arrowStart - spaces, spaces);
                this.report(arrow, 'Unexpected', 'before', fix);
            }
        }
        if (this.after) {
            if (!space.after) {
                var fix = Lint.Replacement.appendText(arrow.end, ' ');
                this.report(arrow, 'Missing', 'after', fix);
            }
        }
        else {
            if (space.after) {
                var fix = Lint.Replacement.deleteText(arrow.end, bodyStart - arrow.end);
                this.report(arrow, 'Unexpected', 'after', fix);
            }
        }
        _super.prototype.visitArrowFunction.call(this, node);
    };
    RuleWalker.prototype.report = function (arrowToken, status, place, fix) {
        var failure = this.createFailure(arrowToken.getStart(this.srcFile), arrowToken.getWidth(this.srcFile), status + " space " + place + " =>.", fix);
        this.addFailure(failure);
    };
    return RuleWalker;
}(Lint.RuleWalker));
var _a, _b, _c, _d;

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
