webpackJsonp([14],{

/***/ 142:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ListPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_sqlite__ = __webpack_require__(91);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ionic_native_file_transfer__ = __webpack_require__(92);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ionic_native_network__ = __webpack_require__(93);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








var ListPage = /** @class */ (function () {
    function ListPage(navCtrl, navParams, sqlite, userAuth, storage, util, transfer, network) {
        var _this = this;
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.sqlite = sqlite;
        this.userAuth = userAuth;
        this.storage = storage;
        this.util = util;
        this.transfer = transfer;
        this.network = network;
        this.data = [];
        this.offine_data = [];
        this.page = 1;
        this.is_next_page = true;
        this.ishown = true;
        storage.get('user_id').then(function (value) {
            _this.user_id = value;
            _this.select_offline_item(_this.user_id);
            if (_this.network.type == 'none') {
                _this.util.presentCustomToast('Currently you are offline!');
            }
            else {
                _this.getData(_this.user_id);
            }
        });
    }
    ListPage.prototype.itemTapped = function (item) {
        // That's right, we're pushing to ourselves!
        this.navCtrl.push("DetailPage", {
            item: item
        });
    };
    ListPage.prototype.getData = function (user_id) {
        var _this = this;
        var Data = new FormData;
        Data.append('user_id', user_id);
        Data.append('page', this.page + "");
        this.util.presentLoading();
        this.userAuth.getListData(Data).then(function (result) {
            console.log('List Response', result);
            _this.util.dismissLoading();
            _this.is_next_page = result['is_next_page'];
            console.log(result['data'].length);
            for (var i = 0; i < result['data'].length; i++) {
                _this.data.push(result['data'][i]);
            }
            _this.page++;
        });
    };
    ListPage.prototype.sync = function (item, index) {
        var _this = this;
        console.log('selected item', item);
        if (item.image) {
            var imagepath = item.image;
            var fileTransfer = this.transfer.create();
            var options = {
                fileKey: 'image',
                chunkedMode: false,
                mimeType: 'multipart/form-data',
                headers: {},
                params: {
                    'user_id': item.user_id,
                    'gender': item.gender,
                    'race': item.race,
                    'oral_hygiene': item.oral_hygiene,
                    'treated_decay': item.treated_decay,
                    'presence': item.presence,
                    'history_rampant_caries': item.history_rampant_caries,
                    'spot_lesions': item.spot_lesions,
                    'age': item.age,
                    'untreated_decay': item.untreated_decay,
                    'treatment_urgency': item.treatment_urgency,
                    'early_childhood_caries': item.early_childhood_caries,
                    'screening_date': item.screening_date,
                    'school_name': item.school_name,
                    'screener_name': item.screener_name
                }
            };
            fileTransfer.upload(imagepath, 'http://git.instaacoders.com/api/add_data.php', options)
                .then(function (data) {
                var response = JSON.parse(data.response);
                // save response in storage
                if (response.success)
                    _this.delete_offline_item(item.id);
                if (_this.offine_data.length - 1 == index) {
                    _this.util.dismissLoading();
                    _this.select_offline_item(_this.user_id);
                    setTimeout(function () {
                        _this.getData(_this.user_id);
                    }, 300);
                    _this.util.presentToast(response.message);
                }
                console.log('response', response);
            }, function (err) {
                console.log(err);
                _this.util.dismissLoading();
            });
        }
        else {
            var Data = new FormData;
            Data.append('user_id', item.user_id + "");
            Data.append('id', item.id + "");
            Data.append('gender', item.gender);
            Data.append('race', item.race);
            Data.append('oral_hygiene', item.Hygiene);
            Data.append('treated_decay', item.treated);
            Data.append('presence', item.sealants);
            Data.append('history_rampant_caries', item.history);
            Data.append('spot_lesions', item.white_spot);
            Data.append('age', item.age);
            Data.append('untreated_decay', item.untreated);
            Data.append('treatment_urgency', item.treatment);
            Data.append('early_childhood_caries', item.childhood);
            Data.append('screening_date', item.screenDate);
            Data.append('school_name', item.school_name);
            Data.append('screener_name', item.screener_name);
            //Data.append('image', this.imageData)
            this.userAuth.insertData(Data).then(function (result) {
                console.log(result);
                if (result['success']) {
                    //Display sucess Toast
                    _this.delete_offline_item(item.id);
                    if (_this.offine_data.length - 1 == index) {
                        _this.select_offline_item(_this.user_id);
                        setTimeout(function () {
                            _this.getData(_this.user_id);
                        }, 300);
                        _this.util.dismissLoading();
                    }
                }
            });
        }
    };
    ListPage.prototype.syncoffline = function (item, index) {
        console.log('selected item', item);
        this.delete_offline_item(item.id);
    };
    ListPage.prototype.upload_offline_data = function () {
        if (this.network.type == 'none') {
            this.util.presentCustomToast('Currently you are offline!');
            // for(let i=0;i< this.offine_data.length;i++){
            //     this.syncoffline(this.offine_data[i], i);
            // }
        }
        else {
            this.util.presentLoading();
            for (var i = 0; i < this.offine_data.length; i++) {
                this.sync(this.offine_data[i], i);
            }
        }
    };
    ListPage.prototype.select_offline_item = function (id) {
        var _this = this;
        this.sqlite.create({
            name: 'datadb.db',
            location: 'default'
        }).then(function (db) {
            db.executeSql('SELECT * FROM screendata where user_id="' + id + '"', [])
                .then(function (res) {
                console.log('Total records', res.rows.length + res.rows.item);
                _this.offine_data = [];
                for (var i = 0; i < res.rows.length; i++) {
                    console.log(res.rows.item(i));
                    _this.offine_data.push(res.rows.item(i));
                }
            })
                .catch(function (e) { return console.log('Error in fetch query', e); });
        });
    };
    ListPage.prototype.delete_offline_item = function (id) {
        var _this = this;
        this.sqlite.create({
            name: 'datadb.db',
            location: 'default'
        }).then(function (db) {
            db.executeSql('DELETE FROM screendata WHERE id=?', [id])
                .then(function (res) {
                console.log(res);
                _this.util.presentCustomToast('Data deleted succesfully!');
            })
                .catch(function (e) { return console.log(e); });
        }).catch(function (e) { return console.log(e); });
    };
    ListPage.prototype.doInfinite = function (infiniteScroll) {
        var _this = this;
        console.log('Begin async operation');
        var Data = new FormData;
        Data.append('user_id', this.user_id);
        Data.append('page', this.page + "");
        if (this.network.type == 'none') {
            this.util.presentCustomToast('Currently you are offline!');
        }
        else {
            this.userAuth.getListData(Data).then(function (result) {
                console.log('List Response', result);
                _this.is_next_page = result['is_next_page'];
                console.log(result['data'].length);
                for (var i = 0; i < result['data'].length; i++) {
                    console.log(result['data'][i]);
                    _this.data.push(result['data'][i]);
                }
                _this.page++;
                infiniteScroll.complete();
                _this.ishown = false;
            });
        }
    };
    ListPage.prototype.pageScroller = function () {
        //scroll to page top
        this.pageTop.scrollToTop();
        this.ishown = true;
    };
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_8" /* ViewChild */])('pageTop'),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["b" /* Content */])
    ], ListPage.prototype, "pageTop", void 0);
    ListPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-list',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\list\list.html"*/'<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <!-- <ion-buttons end>\n\n            <button ion-button (click)="Edit()">\n\n        EDIT\n\n        <ion-icon name="create"></ion-icon>\n\n      </button>\n\n        </ion-buttons> -->\n\n        <ion-title>List</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n<ion-content #pageTop>\n\n    <h2>Not sync (offline) data</h2>\n\n    <button *ngIf="offine_data.length > 0" ion-button block margin (click)="upload_offline_data()">Sync All Data</button>\n\n    <ion-list *ngIf="offine_data.length > 0">\n\n        <ion-row class="head">\n\n            <ion-col>\n\n                <b>Screening Date</b>\n\n            </ion-col>\n\n            <ion-col>\n\n                <b>School Name</b>\n\n            </ion-col>\n\n            <ion-col>\n\n                <b>Screening Name</b>\n\n            </ion-col>\n\n            <ion-col>\n\n                View\n\n            </ion-col>\n\n        </ion-row>\n\n\n\n        <ion-row *ngFor="let item of offine_data" class="text" align-items-center>\n\n            <ion-col>\n\n                {{item.screening_date}}\n\n            </ion-col>\n\n            <ion-col>\n\n                {{item.school_name}}\n\n            </ion-col>\n\n            <ion-col>\n\n                {{item.screener_name}}\n\n            </ion-col>\n\n            <ion-col>\n\n                <button ion-button (click)="itemTapped(item)">View</button>\n\n            </ion-col>\n\n        </ion-row>\n\n    </ion-list>\n\n    <div *ngIf="offine_data.length == 0">No offline data available</div>\n\n\n\n    <h2>Sync (online) data</h2>\n\n    <ion-list *ngIf="data.length > 0">\n\n        <ion-row class="head">\n\n            <ion-col>\n\n                <b>Screening Date</b>\n\n            </ion-col>\n\n            <ion-col>\n\n                <b>School Name</b>\n\n            </ion-col>\n\n            <ion-col>\n\n                <b>Screening Name</b>\n\n            </ion-col>\n\n            <ion-col>\n\n                <b>View</b>\n\n            </ion-col>\n\n        </ion-row>\n\n\n\n        <ion-row *ngFor="let item of data" align-items-center class="text">\n\n            <ion-col>\n\n                {{item.screening_date}}\n\n            </ion-col>\n\n            <ion-col>\n\n                {{item.school_name}}\n\n            </ion-col>\n\n            <ion-col>\n\n                {{item.screener_name}}\n\n            </ion-col>\n\n            <ion-col>\n\n                <button ion-button (click)="itemTapped(item)">View</button>\n\n            </ion-col>\n\n        </ion-row>\n\n    </ion-list>\n\n    <div *ngIf="data.length == 0">No data available</div>\n\n\n\n    <ion-infinite-scroll (ionInfinite)="doInfinite($event)" *ngIf="is_next_page">\n\n        <ion-infinite-scroll-content loadingSpinner="bubbles" loadingText="Loading more data..."></ion-infinite-scroll-content>\n\n    </ion-infinite-scroll>\n\n    <ion-fab right bottom *ngIf="((!is_next_page && !ishown) ||(!ishown))">\n\n        <button ion-fab color="light" (click)="pageScroller()">\n\n            <ion-icon name="ios-arrow-up"></ion-icon>\n\n        </button>\n\n    </ion-fab>\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\list\list.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_sqlite__["a" /* SQLite */],
            __WEBPACK_IMPORTED_MODULE_3__providers_userauth_userauth__["a" /* UserauthProvider */], __WEBPACK_IMPORTED_MODULE_4__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_5__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_6__ionic_native_file_transfer__["a" /* FileTransfer */], __WEBPACK_IMPORTED_MODULE_7__ionic_native_network__["a" /* Network */]])
    ], ListPage);
    return ListPage;
}());

//# sourceMappingURL=list.js.map

/***/ }),

/***/ 164:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RegistrationPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__login_login__ = __webpack_require__(73);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__uploadkycdoc_uploadkycdoc__ = __webpack_require__(72);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







var RegistrationPage = /** @class */ (function () {
    function RegistrationPage(navCtrl, navParams, menu, util, userAuth, storage) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.menu = menu;
        this.util = util;
        this.userAuth = userAuth;
        this.storage = storage;
        this.isValid = false;
        this.regiData = new FormData;
    }
    RegistrationPage.prototype.ionViewDidLoad = function () {
        var _this = this;
        console.log('ionViewDidLoad RegistrationPage');
        this.userAuth.getCountry().then(function (result) {
            //console.log(result);
            _this.countryData = Array.from(result['data']);
            console.log(_this.countryData.length);
            _this.util.dismissLoading();
            if (result['success']) {
            }
        });
    };
    RegistrationPage.prototype.onSelectChange = function (selectedValue) {
        this.isValid = !!this.email && !!this.password && !!this.name && !!this.country && !!this.phoneno;
    };
    RegistrationPage.prototype.login = function () {
        this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__login_login__["a" /* LoginPage */]);
    };
    // public showFingerprintModal() {
    //   this.fingerprintOptions = {
    //     clientId: 'fingerprint-Demo',
    //     clientSecret: 'password', //Only necessary for Android
    //     disableBackup: false  //Only for Android(optional)
    //   }
    //   this.faio.isAvailable().then(result => {
    //     if (result === "finger") {
    //       this.faio.show(this.fingerprintOptions)
    //         .then((result: any) => {
    //           if (result.withFingerprint) {
    //             console.log('Successfully encrypted credentials.');
    //             console.log('Encrypted credentials: ' + result.withFingerprint);
    //             this.util.presentToast('Fingerprint register');
    //           } else if (result.withBackup) {
    //             console.log('Successfully authenticated with backup password!');
    //           } else console.log('Didn\'t authenticate!');
    //         })
    //         .catch((error: any) => console.log(error));
    //     }
    //   });
    // }
    RegistrationPage.prototype.upload = function (event) {
        this.regiData.set('doc[]', '');
        var files = event.target.files;
        console.log(files);
        Array.from(files).forEach(function (file) {
            this.regiData.append('doc[]', file);
        }.bind(this));
    };
    RegistrationPage.prototype.registration = function () {
        var _this = this;
        //console.log(this.regiData.get('doc'));
        this.regiData.append('user_name', this.name);
        this.regiData.append('user_id', this.email);
        this.regiData.append('phone_no', this.phoneno);
        this.regiData.append('password', this.password);
        this.regiData.append('country', this.country);
        this.regiData.append('doctype', this.doctype);
        this.util.presentLoading();
        this.userAuth.regiUser(this.regiData).then(function (result) {
            console.log(result);
            _this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                //this.util.presentToast(result['message']);
                //this.navCtrl.setRoot(LoginPage);
                _this.storage.set('user_id', result['userId']);
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_6__uploadkycdoc_uploadkycdoc__["a" /* UploadKYCDocPage */]);
            }
            else {
                _this.util.presentToast(result['message']);
            }
        });
    };
    RegistrationPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: "page-registration",template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\register\register.html"*/'<ion-content  class="animated fadeIn login auth-page no-scroll">\n\n    <div class="login-content">\n\n        <div  text-center class="animated fadeInDown" style="height: 250px; overflow: hidden;">\n\n            <img width="100%" height="auto" class="logo" src="assets/imgs/logo_new_2.png">\n\n            <br>\n\n\n\n        </div>\n\n        <div style="text-align: center;">\n\n            <span style="font-size: 20px;">Registration to <br><strong>SARE GGN Buyers</strong></span>\n\n        </div>\n\n        <div class="list-form"> \n\n\n\n            <ion-item>\n\n                <ion-label floating>\n\n                    <ion-icon name="person" item-start class="text-primary">\n\n\n\n                    </ion-icon>\n\n                    Name\n\n                </ion-label>\n\n                <ion-input type="text" [(ngModel)]="name"\n\n                           (ionChange)="onSelectChange($event)"></ion-input>\n\n            </ion-item>\n\n            <ion-item>\n\n                <ion-label floating>\n\n                    <ion-icon name="mail" item-start class="text-primary"></ion-icon>\n\n                    Email\n\n                </ion-label>\n\n                <ion-input type="email" [(ngModel)]="email" (ionChange)="onSelectChange($event)"></ion-input>\n\n            </ion-item>\n\n            <ion-item>\n\n                <ion-label floating>\n\n                    <ion-icon name="lock" item-start class="text-primary">\n\n                    </ion-icon>\n\n                    Password\n\n                </ion-label>\n\n                <ion-input type="password"\n\n                           (ionChange)="onSelectChange($event)" [(ngModel)]="password"></ion-input>\n\n            </ion-item>\n\n            <ion-item>\n\n                <ion-label floating>\n\n                    <ion-icon name="call" item-start class="text-primary"></ion-icon>\n\n                    Phone No\n\n                </ion-label>\n\n                <ion-input type="text" [(ngModel)]="phoneno" (ionChange)="onSelectChange($event)">\n\n                </ion-input>\n\n            </ion-item>\n\n\n\n            <!-- <ion-item>\n\n                <ion-label floating><ion-icon name="calendar" item-start class="text-primary"></ion-icon>Date of Birth</ion-label>\n\n                <ion-datetime id="dynamicDisabled" displayFormat="MM DD YYYY" [(ngModel)]="dob" (ionChange)="onSelectChange($event)"></ion-datetime>\n\n              </ion-item> -->\n\n\n\n            <ion-item>\n\n\n\n                {{countryData}}\n\n                <ion-label floating>\n\n                    <ion-icon name="home" item-start\n\n                              class="text-primary">\n\n                    </ion-icon>\n\n                    Country\n\n                </ion-label>\n\n\n\n                <ion-select [(ngModel)]="country">\n\n                    <ion-option *ngFor="let cdata of countryData" [value]="cdata.cname"\n\n                                [selected]="cdata.cname == \'India\'">{{cdata.cname}}</ion-option>\n\n                </ion-select>\n\n            </ion-item>\n\n\n\n\n\n            <!-- <ion-item><ion-label floating><ion-icon name="home" item-start class="text-primary"></ion-icon>State\n\n            </ion-label><ion-input type="text" [(ngModel)]="state" (ionChange)="onSelectChange($event)">\n\n            </ion-input></ion-item> -->\n\n\n\n            <!-- <ion-item>\n\n                <ion-label floating><ion-icon name="home" item-start\n\n                    class="text-primary">\n\n                </ion-icon>City</ion-label>\n\n                <ion-input type="text" [(ngModel)]="city" (ionChange)="onSelectChange($event)"></ion-input>\n\n            </ion-item> -->\n\n            <br></div>\n\n        <div padding>\n\n            <button (click)="registration()"\n\n                     ion-button block>KYC and other documents\n\n            </button>\n\n            <button expand="block" ion-button block\n\n                    color="secondary" (click)="login()">\n\n                <ion-icon name="arrow-back"></ion-icon> &nbsp; Back\n\n            </button>\n\n        </div>\n\n    </div>\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\register\register.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__["a" /* UserauthProvider */], __WEBPACK_IMPORTED_MODULE_4__ionic_storage__["b" /* Storage */]])
    ], RegistrationPage);
    return RegistrationPage;
}());

//# sourceMappingURL=register.js.map

/***/ }),

/***/ 165:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ShowquestionsPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__showuserans_showuserans__ = __webpack_require__(56);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






/**
 * Generated class for the ShowquestionsPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var ShowquestionsPage = /** @class */ (function () {
    function ShowquestionsPage(navCtrl, navParams, userAuth, menu, storage, util) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.menu = menu;
        this.storage = storage;
        this.util = util;
    }
    ShowquestionsPage.prototype.ionViewDidLoad = function () {
        var _this = this;
        this.menu.enable(true);
        this.userAuth.getQues().then(function (res) {
            _this.quesId = res['data'][0]['id'];
            _this.msg = res['data'][0]['ques'];
        });
        this.storage.get("user_id").then(function (value) {
            _this.user_id = value;
        });
    };
    ShowquestionsPage.prototype.saveVote = function () {
        var _this = this;
        var ansData = new FormData;
        ansData.append('qid', this.quesId);
        ansData.append('uid', this.user_id);
        ansData.append('ans', this.ans);
        this.util.presentLoading();
        this.userAuth.insertAns(ansData).then(function (result) {
            //console.log(result);
            _this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                _this.util.presentToast(result['message']);
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__showuserans_showuserans__["a" /* ShowuseransPage */]);
            }
            else {
                _this.util.presentToast(result['message']);
            }
        });
    };
    ShowquestionsPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-showquestions',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\showquestions\showquestions.html"*/'<!--\n\n  Generated template for the ShowquestionsPage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>Vote here</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n\n\n<ion-content padding>\n\n    <h3>Vote</h3>\n\n    <h5>Question: {{msg}} </h5>\n\n\n\n    <ion-list radio-group [(ngModel)]="ans">\n\n        <ion-item>\n\n            <ion-label>Yes</ion-label>\n\n            <ion-radio value="1" aria-checked="true"></ion-radio>\n\n        </ion-item>\n\n\n\n\n\n        <ion-item>\n\n            <ion-label>No</ion-label>\n\n            <ion-radio value="0"></ion-radio>\n\n        </ion-item>\n\n    </ion-list>\n\n    <button (click)="saveVote()" ion-button block>Submit</button>\n\n</ion-content>\n\n\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\showquestions\showquestions.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_2__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */]])
    ], ShowquestionsPage);
    return ShowquestionsPage;
}());

//# sourceMappingURL=showquestions.js.map

/***/ }),

/***/ 166:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UserdeavtivePage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__login_login__ = __webpack_require__(73);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};



/**
 * Generated class for the UserdeavtivePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var UserdeavtivePage = /** @class */ (function () {
    function UserdeavtivePage(navCtrl, navParams) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
    }
    UserdeavtivePage.prototype.ionViewDidLoad = function () {
        console.log('ionViewDidLoad UserdeavtivePage');
    };
    UserdeavtivePage.prototype.login = function () {
        this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_2__login_login__["a" /* LoginPage */]);
    };
    UserdeavtivePage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-userdeavtive',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\userdeavtive\userdeavtive.html"*/'<!--\n\n  Generated template for the UserdeavtivePage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n\n\n    <ion-navbar color="primary">\n\n        <ion-title>Pending approval</ion-title>\n\n    </ion-navbar>\n\n\n\n</ion-header>\n\n\n\n\n\n<ion-content padding>\n\n    <h4>Your account activation is pending with admin.</h4>\n\n\n\n    <button expand="block" ion-button block color="secondary" (click)="login()">\n\n        <ion-icon name="arrow-back"></ion-icon> &nbsp; Back\n\n    </button>\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\userdeavtive\userdeavtive.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */]])
    ], UserdeavtivePage);
    return UserdeavtivePage;
}());

//# sourceMappingURL=userdeavtive.js.map

/***/ }),

/***/ 167:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EditprofilePage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__otpverification_otpverification__ = __webpack_require__(55);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Generated class for the EditprofilePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var EditprofilePage = /** @class */ (function () {
    function EditprofilePage(navCtrl, navParams, userAuth, menu, storage, util, alertCtrl) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.menu = menu;
        this.storage = storage;
        this.util = util;
        this.alertCtrl = alertCtrl;
        this.isValid = false;
        this.regiData = new FormData;
    }
    EditprofilePage.prototype.ionViewDidLoad = function () {
        var _this = this;
        this.userAuth.getCountry().then(function (result) {
            //console.log(result);
            _this.countryData = Array.from(result['data']);
            console.log(_this.countryData.length);
            _this.util.dismissLoading();
            if (result['success']) {
            }
        });
        this.storage.get("user_id").then(function (value) {
            _this.user_id = value;
            //console.log('this is profile edit page');
            //console.log(this.user_id);
            _this.userAuth.editProfile(_this.user_id).then(function (result) {
                console.log(result['data']);
                _this.userId = result['data'].user_no;
                _this.name = result['data'].user_name;
                _this.email = result['data'].user_id;
                _this.phoneno = result['data'].phone_no;
                _this.city = result['data'].uCity;
                _this.state = result['data'].uState;
                _this.dob = result['data'].dob;
                _this.country = result['data'].country;
            });
        });
    };
    EditprofilePage.prototype.onSelectChange = function (selectedValue) {
        if (this.email != '' && this.name != '' && this.city != '' && this.state != '' && this.phoneno != '')
            this.isValid = true;
        else
            this.isValid = false;
    };
    EditprofilePage.prototype.updateProfile = function () {
        var _this = this;
        this.regiData.append('name', this.name);
        this.regiData.append('email', this.email);
        this.regiData.append('phone', this.phoneno);
        this.regiData.append('city', this.city);
        this.regiData.append('state', this.state);
        this.regiData.append('dob', this.dob);
        this.regiData.append('user_id', this.userId);
        this.regiData.append('country', this.country);
        this.util.presentLoading();
        this.userAuth.updateProfile(this.regiData).then(function (result) {
            console.log(result);
            _this.util.dismissLoading();
            if (result['success']) {
                _this.storage.set('dataEdit', 1);
                _this.sendOtp();
                // console.log('yes updated');
                //Display sucess Toast
                //this.util.presentToast(result['message']);
                //this.navCtrl.setRoot(LoginPage);
                //this.storage.set('userId', result['userId']);
                //this.navCtrl.setRoot(UploadkycdocPage);
            }
            else {
                _this.util.presentToast(result['message']);
            }
        });
    };
    EditprofilePage.prototype.sendOtp = function () {
        var _this = this;
        this.storage.get("user_id").then(function (value) {
            _this.userId = value;
            console.log(_this.userId);
            _this.util.presentLoading();
            _this.userAuth.sendOtp(_this.userId).then(function (result) {
                console.log(result);
                _this.util.dismissLoading();
                if (result['success']) {
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__otpverification_otpverification__["a" /* OtpverificationPage */]);
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        });
    };
    EditprofilePage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-editprofile',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\editprofile\editprofile.html"*/'<!--\n\n  Generated template for the EditprofilePage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>Edit Profile</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n\n\n<ion-content padding>\n\n\n\n    <ion-item>\n\n        <ion-label floating>\n\n            <ion-icon name="person" item-start class="text-primary"></ion-icon>\n\n            Name\n\n        </ion-label>\n\n        <ion-input type="text" [(ngModel)]="name"\n\n                   (ionChange)="onSelectChange($event)"></ion-input>\n\n    </ion-item>\n\n    <ion-item>\n\n        <ion-label floating>\n\n            <ion-icon name="mail" item-start class="text-primary"></ion-icon>\n\n            Email\n\n        </ion-label>\n\n        <ion-input type="email" readonly [(ngModel)]="email" (ionChange)="onSelectChange($event)"></ion-input>\n\n    </ion-item>\n\n    <ion-item>\n\n        <ion-label floating>\n\n            <ion-icon name="call" item-start class="text-primary"></ion-icon>\n\n            Phone No\n\n        </ion-label>\n\n        <ion-input type="text" [(ngModel)]="phoneno" (ionChange)="onSelectChange($event)"></ion-input>\n\n    </ion-item>\n\n\n\n    <ion-item>\n\n\n\n        <ion-label floating>\n\n            <ion-icon name="home" item-start\n\n                      class="text-primary">\n\n            </ion-icon>\n\n            Country\n\n        </ion-label>\n\n\n\n        <ion-select [(ngModel)]="country">\n\n            <ion-option *ngFor="let cdata of countryData" [value]="cdata.cname"\n\n                        [selected]="cdata.cname == \'India\'">{{cdata.cname}}</ion-option>\n\n        </ion-select>\n\n    </ion-item>\n\n\n\n\n\n    <br>\n\n    <div padding>\n\n        <button (click)="updateProfile()" ion-button block>Update</button>\n\n    </div>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\editprofile\editprofile.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_2__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */], __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["a" /* AlertController */]])
    ], EditprofilePage);
    return EditprofilePage;
}());

//# sourceMappingURL=editprofile.js.map

/***/ }),

/***/ 168:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EditdocsPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__otpverification_otpverification__ = __webpack_require__(55);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};






/**
 * Generated class for the EditdocsPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var EditdocsPage = /** @class */ (function () {
    function EditdocsPage(navCtrl, navParams, userAuth, menu, storage, util) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.menu = menu;
        this.storage = storage;
        this.util = util;
        this.regiData = new FormData;
        console.log(this.navParams.data.imgId + 'params');
        this.imageId = this.navParams.data.imgId;
    }
    EditdocsPage.prototype.ionViewDidLoad = function () {
        //console.log(this.imageId+'this is ');
    };
    EditdocsPage.prototype.upload = function (file) {
        //console.log(file[0])
        this.doc = file[0];
        this.regiData.append('doc', this.doc);
    };
    EditdocsPage.prototype.updateDoc = function () {
        var _this = this;
        // console.log(this.imageId+'this is ');
        this.storage.get("user_id").then(function (value) {
            _this.userId = value;
            _this.util.presentLoading();
            //console.log(this.regiData);
            // console.log('yes here in edit docs');
            //console.log(this.imageId);
            _this.userAuth.updateDoc(_this.regiData, _this.userId, _this.imageId).then(function (result) {
                // console.log(result);
                _this.util.dismissLoading();
                if (result['success']) {
                    _this.storage.set('dataEdit', 1);
                    _this.sendOtp();
                    //Display sucess Toast
                    //this.util.presentToast(result['message']);
                    //this.navCtrl.setRoot(LoginPage);
                    //this.storage.set('userId', result['userId']);
                    //this.navCtrl.setRoot(UploadkycdocPage);
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        });
    };
    EditdocsPage.prototype.sendOtp = function () {
        var _this = this;
        this.storage.get("user_id").then(function (value) {
            _this.userId = value;
            console.log(_this.userId);
            _this.util.presentLoading();
            _this.userAuth.sendOtp(_this.userId).then(function (result) {
                console.log(result);
                _this.util.dismissLoading();
                if (result['success']) {
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__otpverification_otpverification__["a" /* OtpverificationPage */]);
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        });
    };
    EditdocsPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-editdocs',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\editdocs\editdocs.html"*/'<!--\n\n  Generated template for the EditdocsPage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>Update Document</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n<ion-content padding>\n\n\n\n    <ion-label>Upload Documnet</ion-label>\n\n    <input type="file" id="doc" name="doc[]" (change)="upload($event.target.files)"/>\n\n    <button (click)="updateDoc()" ion-button block>Update Document</button>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\editdocs\editdocs.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_3__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_4__providers_util_util__["a" /* UtilProvider */]])
    ], EditdocsPage);
    return EditdocsPage;
}());

//# sourceMappingURL=editdocs.js.map

/***/ }),

/***/ 17:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UserauthProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_common_http__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_http__ = __webpack_require__(296);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_storage__ = __webpack_require__(19);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




/*
  Generated class for the UserauthProvider provider.

  See https://angular.io/guide/dependency-injection for more info on providers
  and Angular DI.
*/
var UserauthProvider = /** @class */ (function () {
    function UserauthProvider(http, storage) {
        this.http = http;
        this.storage = storage;
        this.apiUrl = 'https://git.instaacoders.com/api/';
        // console.log('Hello UserauthProvider Provider');
        var headers = new __WEBPACK_IMPORTED_MODULE_2__angular_http__["a" /* Headers */]();
        headers.append('Access-Control-Allow-Origin', '*');
        headers.append('Access-Control-Allow-Methods', 'POST, GET, OPTIONS, PUT');
        headers.append('Accept', 'application/json');
        this.options = new __WEBPACK_IMPORTED_MODULE_2__angular_http__["c" /* RequestOptions */]({ headers: headers, withCredentials: true });
    }
    UserauthProvider.prototype.handleLoginSuccess = function (userID) {
        this.storage.set('isLogin', true);
        this.storage.set('user_id', userID);
    };
    UserauthProvider.prototype.loginUser = function (data) {
        return this.http.post(this.apiUrl + 'login.php', data).toPromise();
    };
    UserauthProvider.prototype.regiUser = function (data) {
        return this.http.post(this.apiUrl + 'reg_user.php', data).toPromise();
    };
    UserauthProvider.prototype.insertData = function (data) {
        return this.http.post(this.apiUrl + 'add_data.php', data).toPromise();
    };
    UserauthProvider.prototype.insertAns = function (data) {
        return this.http.post(this.apiUrl + 'set_ans.php', data).toPromise();
    };
    UserauthProvider.prototype.getQues = function () {
        return this.http.get(this.apiUrl + 'get_ques.php').toPromise();
    };
    UserauthProvider.prototype.getUserAns = function ($userId) {
        return this.http.get(this.apiUrl + 'get_user_ans.php?user_id=' + $userId).toPromise();
    };
    UserauthProvider.prototype.viewProfile = function ($userId) {
        return this.http.get(this.apiUrl + 'view-profile.php?user_id=' + $userId).toPromise();
    };
    UserauthProvider.prototype.editProfile = function ($userId) {
        return this.http.get(this.apiUrl + 'edit-profile.php?user_id=' + $userId).toPromise();
    };
    UserauthProvider.prototype.uploadKycimg = function ($data, $userId) {
        //console.log('get user profile');
        //console.log($userId);
        return this.http.post(this.apiUrl + 'upload_kyc_image.php?user_id=' + $userId, $data).toPromise();
    };
    UserauthProvider.prototype.updateDoc = function ($data, $userId, $imageId) {
        return this.http.post(this.apiUrl + 'update_kyc_image.php?user_id=' + $userId + '&img_id=' + $imageId, $data).toPromise();
    };
    UserauthProvider.prototype.updateProfile = function ($data) {
        return this.http.post(this.apiUrl + 'update-profile.php', $data).toPromise();
    };
    UserauthProvider.prototype.getListData = function (data) {
        return this.http.post(this.apiUrl + 'data_info.php', data).toPromise();
    };
    // new edit data added
    UserauthProvider.prototype.editData = function (data) {
        return this.http.post(this.apiUrl + 'edit_data.php', data).toPromise();
    };
    UserauthProvider.prototype.getCountry = function () {
        return this.http.get(this.apiUrl + 'get_countries.php').toPromise();
    };
    UserauthProvider.prototype.fblogin = function (name, email) {
        return this.http.get(this.apiUrl + 'fb_login.php?name=' + name + '&email=' + email).toPromise();
    };
    UserauthProvider.prototype.loginWithApple = function (data) {
        return this.http.post(this.apiUrl + 'apple_login.php', data).toPromise();
    };
    UserauthProvider.prototype.verfyOtp = function (email, otp) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.http.get(_this.apiUrl + 'verify-otp.php?user_id=' + email + '&otp=' + otp)
                .subscribe(function (res) {
                resolve(res);
            }, function (err) {
                reject(err);
            });
        });
    };
    UserauthProvider.prototype.sendOtp = function (user_id) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.http.get(_this.apiUrl + 'send-otp.php?user_id=' + user_id)
                .subscribe(function (res) {
                resolve(res);
            }, function (err) {
                reject(err);
            });
        });
    };
    UserauthProvider.prototype.getRegistermsg = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.http.get(_this.apiUrl + 'register-message.php')
                .subscribe(function (res) {
                resolve(res);
            }, function (err) {
                reject(err);
            });
        });
    };
    UserauthProvider.prototype.getUpdatemsg = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            _this.http.get(_this.apiUrl + 'update-message.php')
                .subscribe(function (res) {
                resolve(res);
            }, function (err) {
                reject(err);
            });
        });
    };
    UserauthProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_0__angular_common_http__["b" /* HttpClient */], __WEBPACK_IMPORTED_MODULE_3__ionic_storage__["b" /* Storage */]])
    ], UserauthProvider);
    return UserauthProvider;
}());

//# sourceMappingURL=userauth.js.map

/***/ }),

/***/ 20:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UtilProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};


/*
  Generated class for the UtilProvider provider.

  See https://angular.io/guide/dependency-injection for more info on providers
  and Angular DI.
*/
var UtilProvider = /** @class */ (function () {
    function UtilProvider(loadingCtrl, toastCtrl) {
        this.loadingCtrl = loadingCtrl;
        this.toastCtrl = toastCtrl;
        console.log('Hello UtilProvider Provider');
    }
    /**
     * Show the spinner/loading until this promise is completed.
     * @param promise
     */
    UtilProvider.prototype.showLoadingFor = function (promise) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.presentLoading()];
                    case 1:
                        _a.sent();
                        promise.then(function () {
                            _this.dismissLoading();
                        }, function () {
                            _this.dismissLoading();
                        });
                        return [2 /*return*/];
                }
            });
        });
    };
    UtilProvider.prototype.presentLoading = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.loading = this.loadingCtrl.create({
                            spinner: 'bubbles',
                            content: 'Please wait...'
                        });
                        this.loading.onDidDismiss(function () {
                            console.log('Dismissed loading');
                        });
                        return [4 /*yield*/, this.loading.present()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    UtilProvider.prototype.dismissLoading = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                if (this.loading) {
                    this.loading.dismiss();
                    delete this.loading;
                }
                return [2 /*return*/];
            });
        });
    };
    UtilProvider.prototype.presentToast = function (message) {
        var toast = this.toastCtrl.create({
            message: message,
            duration: 2000
        });
        toast.present();
    };
    UtilProvider.prototype.presentCustomToast = function (message) {
        var toast = this.toastCtrl.create({
            message: message,
            duration: 2000,
            position: 'bottom',
            cssClass: 'dark-trans',
            closeButtonText: 'OK',
            showCloseButton: true
        });
        toast.present();
    };
    UtilProvider.prototype.presentErrorToast = function (message) {
        var toast = this.toastCtrl.create({
            message: message,
            duration: 2000,
            position: 'bottom',
            cssClass: 'error-toast',
            closeButtonText: 'OK',
            showCloseButton: true
        });
        toast.present();
    };
    UtilProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["g" /* LoadingController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["m" /* ToastController */]])
    ], UtilProvider);
    return UtilProvider;
}());

//# sourceMappingURL=util.js.map

/***/ }),

/***/ 203:
/***/ (function(module, exports) {

function webpackEmptyAsyncContext(req) {
	// Here Promise.resolve().then() is used instead of new Promise() to prevent
	// uncatched exception popping up in devtools
	return Promise.resolve().then(function() {
		throw new Error("Cannot find module '" + req + "'.");
	});
}
webpackEmptyAsyncContext.keys = function() { return []; };
webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext;
module.exports = webpackEmptyAsyncContext;
webpackEmptyAsyncContext.id = 203;

/***/ }),

/***/ 245:
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"../pages/add-kyc/add-kyc.module": [
		488,
		2
	],
	"../pages/detail/detail.module": [
		489,
		1
	],
	"../pages/editdocs/editdocs.module": [
		499,
		13
	],
	"../pages/editprofile/editprofile.module": [
		492,
		12
	],
	"../pages/fblogin/fblogin.module": [
		490,
		11
	],
	"../pages/login-finger/login-finger.module": [
		491,
		10
	],
	"../pages/login/login.module": [
		500,
		9
	],
	"../pages/mfile/mfile.module": [
		251
	],
	"../pages/otpverification/otpverification.module": [
		497,
		8
	],
	"../pages/register/register.module": [
		493,
		7
	],
	"../pages/showquestions/showquestions.module": [
		494,
		6
	],
	"../pages/showuserans/showuserans.module": [
		495,
		5
	],
	"../pages/sidemenu/sidemenu.module": [
		496,
		0
	],
	"../pages/uploadkycdoc/uploadkycdoc.module": [
		253
	],
	"../pages/userdeavtive/userdeavtive.module": [
		498,
		4
	],
	"../pages/viewprofile/viewprofile.module": [
		501,
		3
	]
};
function webpackAsyncContext(req) {
	var ids = map[req];
	if(!ids)
		return Promise.reject(new Error("Cannot find module '" + req + "'."));
	return Promise.all(ids.slice(1).map(__webpack_require__.e)).then(function() {
		return __webpack_require__(ids[0]);
	});
};
webpackAsyncContext.keys = function webpackAsyncContextKeys() {
	return Object.keys(map);
};
webpackAsyncContext.id = 245;
module.exports = webpackAsyncContext;

/***/ }),

/***/ 250:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return HomePage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_camera__ = __webpack_require__(141);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_sqlite__ = __webpack_require__(91);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ionic_native_file_transfer__ = __webpack_require__(92);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__ionic_native_network__ = __webpack_require__(93);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__list_list__ = __webpack_require__(142);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};










var HomePage = /** @class */ (function () {
    function HomePage(navCtrl, camera, menu, transfer, sqlite, storage, util, userAuth, network) {
        var _this = this;
        this.navCtrl = navCtrl;
        this.camera = camera;
        this.menu = menu;
        this.transfer = transfer;
        this.sqlite = sqlite;
        this.storage = storage;
        this.util = util;
        this.userAuth = userAuth;
        this.network = network;
        this.screenDate = "";
        this.school_name = "";
        this.screener_name = "";
        this.gender = "";
        this.race = "";
        this.Hygiene = "";
        this.treated = [];
        this.sealants = "";
        this.history = "";
        this.white_spot = "";
        this.untreated = "";
        this.treatment = "";
        this.childhood = "";
        this.age = "";
        this.menu.enable(true);
        this.createDB();
        this.storage.get("user_id").then(function (value) {
            console.log("Login user id", value);
            _this.user_id = value;
        });
    }
    HomePage.prototype.takePicture = function () {
        var _this = this;
        var options = {
            quality: 100,
            destinationType: this.camera.DestinationType.FILE_URI,
            encodingType: this.camera.EncodingType.JPEG,
            mediaType: this.camera.MediaType.PICTURE
        };
        this.camera.getPicture(options).then(function (imageData) {
            console.log("imageData : ", imageData);
            _this.imageData = imageData;
        }, function (err) {
            // Handle error
            console.log("Camera image error", err);
        });
    };
    HomePage.prototype.saveData = function () {
        console.log("treated", this.treated);
        var treat_urgency = "";
        for (var i = 0; i < this.treated.length; i++) {
            treat_urgency += this.treated[i];
            if (i < this.treated.length - 1)
                treat_urgency += ",";
        }
        this.treated = treat_urgency;
        console.log("treat_urgency", treat_urgency);
        console.log("network connection type: ", this.network.type);
        console.log("image Data", this.imageData);
        // console.log('screener_name=', this.screener_name);
        if (this.screenDate === "" || this.screenDate === "undefined") {
            this.util.presentCustomToast("Please select Screen Date");
        }
        else if (this.school_name === "" || this.school_name === "undefined") {
            this.util.presentCustomToast("Please Enter School Name");
        }
        else if (this.screener_name === "" ||
            this.screener_name === "undefined") {
            this.util.presentCustomToast("Please Enter Screener Name");
        }
        else if (this.gender === "" || this.gender === "undefined") {
            this.util.presentCustomToast("Please select your gender");
        }
        else if (this.gender === "" || this.gender === "undefined") {
            this.util.presentCustomToast("Please select your gender");
        }
        else if (this.race === "" || this.race === "undefined") {
            this.util.presentCustomToast("Please select your Race/Ethnicity.");
        }
        else if (this.Hygiene === "" || this.Hygiene === "undefined") {
            this.util.presentCustomToast("Please select your Oral Hygiene.");
        }
        else if (this.treated === "" || this.treated === "undefined") {
            this.util.presentCustomToast("Please select your Treated Decay.");
        }
        else if (this.sealants === "" || this.sealants === "undefined") {
            this.util.presentCustomToast("Please select your Presence of Dental Sealants.");
        }
        else if (this.history === "" || this.history === "undefined") {
            this.util.presentCustomToast("Please select your History of Rampant Caries?.");
        }
        else if (this.white_spot === "" || this.white_spot === "undefined") {
            this.util.presentCustomToast("Please select your White Spot Lesions?.");
        }
        else if (this.age === "" || this.age === "undefined") {
            this.util.presentCustomToast("Please select proper age.");
        }
        else if (this.untreated === "" || this.untreated === "undefined") {
            this.util.presentCustomToast("Please select Untreated Decay.");
        }
        else if (this.treatment === "" || this.treatment === "undefined") {
            this.util.presentCustomToast("Please select Treatment Urgency.");
        }
        else if (this.childhood === "" || this.childhood === "undefined") {
            this.util.presentCustomToast("Please select Early Childhood Caries?.");
        }
        else {
            if (!this.imageData) {
                this.imageData = "";
            }
            if (this.network.type == "none")
                this.save_data_offile();
            else
                this.uploadData();
        }
    };
    HomePage.prototype.save_data_offile = function () {
        var _this = this;
        console.log(this.screenDate +
            "-" +
            this.gender +
            "-" +
            this.race +
            "-" +
            this.Hygiene +
            "-" +
            this.treated +
            "-" +
            this.sealants +
            "-" +
            this.history +
            "-" +
            this.white_spot +
            "-" +
            this.untreated +
            "-" +
            this.treatment +
            "-" +
            this.childhood);
        this.sqlite
            .create({
            name: "datadb.db",
            location: "default"
        })
            .then(function (db) {
            //Insert record
            db.executeSql("INSERT INTO screendata VALUES(NULL,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", [
                _this.screenDate,
                _this.school_name,
                _this.screener_name,
                _this.gender,
                _this.race,
                _this.Hygiene,
                _this.treated,
                _this.sealants,
                _this.history,
                _this.white_spot,
                _this.age,
                _this.untreated,
                _this.treatment,
                _this.childhood,
                _this.imageData,
                _this.user_id
            ])
                .then(function (res) {
                console.log("insert result", res);
                _this.util.presentCustomToast("Data is saved...");
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_9__list_list__["a" /* ListPage */]);
            })
                .catch(function (e) { return console.log("insert query error: ", e); });
        })
            .catch(function (e) { return console.log("Open DB Create DB", e); });
    };
    HomePage.prototype.uploadData = function () {
        var _this = this;
        var imagepath = this.imageData;
        if (imagepath != '') {
            this.util.presentLoading();
            var fileTransfer = this.transfer.create();
            var options = {
                fileKey: "image",
                chunkedMode: false,
                mimeType: "multipart/form-data",
                headers: {},
                params: {
                    user_id: this.user_id,
                    gender: this.gender,
                    race: this.race,
                    oral_hygiene: this.Hygiene,
                    treated_decay: this.treated,
                    presence: this.sealants,
                    history_rampant_caries: this.history,
                    spot_lesions: this.white_spot,
                    age: this.age,
                    untreated_decay: this.untreated,
                    treatment_urgency: this.treatment,
                    early_childhood_caries: this.childhood,
                    screening_date: this.screenDate,
                    school_name: this.school_name,
                    screener_name: this.screener_name
                }
            };
            fileTransfer
                .upload(imagepath, "http://git.instaacoders.com/api/add_data.php", options)
                .then(function (data) {
                var response = JSON.parse(data.response);
                // save response in storage
                _this.util.dismissLoading();
                _this.util.presentToast(response.message);
                console.log("response", response);
            }, function (err) {
                console.log(err);
            });
        }
        else {
            this.uploadOnlyData();
        }
    };
    HomePage.prototype.createDB = function () {
        this.sqlite
            .create({
            name: "datadb.db",
            location: "default"
        })
            .then(function (db) {
            console.log("CREATE TABLE IF NOT EXISTS screendata(id INTEGER PRIMARY KEY," +
                "screening_date TEXT,school_name TEXT,screener_name TEXT, gender TEXT, race TEXT, oral_hygiene TEXT, treated_decay TEXT, presence TEXT," +
                "history_rampant_caries TEXT, spot_lesions TEXT, age TEXT, untreated_decay TEXT, treatment_urgency TEXT, early_childhood_caries TEXT, image TEXT," +
                "user_id TEXT)");
            db.executeSql("CREATE TABLE IF NOT EXISTS screendata(id INTEGER PRIMARY KEY," +
                "screening_date TEXT,school_name TEXT,screener_name TEXT, gender TEXT, race TEXT, oral_hygiene TEXT, treated_decay TEXT, presence TEXT," +
                "history_rampant_caries TEXT, spot_lesions TEXT, age TEXT, untreated_decay TEXT, treatment_urgency TEXT, early_childhood_caries TEXT, image TEXT," +
                "user_id TEXT)", [])
                .then(function (res) { return console.log("create result", res); })
                .catch(function (e) { return console.log("create DB query error: ", e); });
        })
            .catch(function (e) { return console.log("OPEN DB Query", e); });
    };
    HomePage.prototype.uploadOnlyData = function () {
        var _this = this;
        var Data = new FormData;
        Data.append('user_id', this.user_id + "");
        Data.append('gender', this.gender);
        Data.append('race', this.race);
        Data.append('oral_hygiene', this.Hygiene);
        Data.append('treated_decay', this.treated);
        Data.append('presence', this.sealants);
        Data.append('history_rampant_caries', this.history);
        Data.append('spot_lesions', this.white_spot);
        Data.append('age', this.age);
        Data.append('untreated_decay', this.untreated);
        Data.append('treatment_urgency', this.treatment);
        Data.append('early_childhood_caries', this.childhood);
        Data.append('screening_date', this.screenDate);
        Data.append('school_name', this.school_name);
        Data.append('screener_name', this.screener_name);
        Data.append('image', this.imageData);
        this.util.presentLoading();
        this.userAuth.insertData(Data).then(function (result) {
            console.log(result);
            _this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                _this.util.presentToast(result['message']);
            }
            else {
                _this.util.presentToast(result['message']);
            }
        });
    };
    HomePage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: "page-home",template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\home\home.html"*/'<!--\n\n  Generated template for the NextPage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n\n\n    <ion-navbar color="dark">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>SARE GGN Buyers</ion-title>\n\n        <!--<ion-buttons end>\n\n      <button ion-button icon-only (click)="save()"><ion-icon name="send"></ion-icon></button>\n\n    </ion-buttons>-->\n\n    </ion-navbar>\n\n\n\n</ion-header>\n\n\n\n\n\n<ion-content padding="true" style="background-color:#fffee4;">\n\n    <h3 text-wrap style="color:black; font-size:20px; font-weight:bold; line-height:1;">Preventive Services Program (PSP) Survey</h3>\n\n\n\n    <ion-row style="background-color:black; border:thin;">\n\n\n\n        <ion-col width-70>\n\n            <ion-datetime style="background-color:#fffee4; font-size:12px;" displayFormat="YYYY/MM/DD" [(ngModel)]="screenDate"\n\n                          placeholder="Screening Date:"></ion-datetime>\n\n        </ion-col>\n\n        <ion-col width-70>\n\n            <ion-input type="text" [(ngModel)]="school_name" placeholder="School Name (Print, Stamp, or affix a label):"\n\n                       style="background-color:#fffee4; font-size:12px;"></ion-input>\n\n        </ion-col>\n\n        <ion-col width-70>\n\n            <ion-input type="text" [(ngModel)]="screener_name" placeholder="Screener Name:"\n\n                       style="background-color:#fffee4; font-size:12px;"></ion-input>\n\n        </ion-col>\n\n    </ion-row>\n\n    <ion-card style="background-color:#fffee4; margin-top:10px;">\n\n        <h3 style="color:black; font-size:18px; ">DO NOT LEAVE ANY QUESTIONS UNANSWERED</h3>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            1. Gender:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="gender">\n\n            <ion-item>\n\n                <ion-label>Male</ion-label>\n\n                <ion-radio value="male" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Female</ion-label>\n\n                <ion-radio value="female"></ion-radio>\n\n            </ion-item>\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            2. Race/Ethnicity:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="race" margin-top>\n\n            <ion-item>\n\n                <ion-label>White</ion-label>\n\n                <ion-radio value="White" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>African-American</ion-label>\n\n                <ion-radio value="African-American"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Asian or Pacific Islander</ion-label>\n\n                <ion-radio value="Asian or Pacific Islander"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>American Indian</ion-label>\n\n                <ion-radio value="American Indian"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Multi-Racial</ion-label>\n\n                <ion-radio value="Multi-Racial"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Unknown (Non White)</ion-label>\n\n                <ion-radio value="Unknown (Non White)"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Hispanic</ion-label>\n\n                <ion-radio value="Hispanic"></ion-radio>\n\n            </ion-item>\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            3. Oral Hygiene:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="Hygiene" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Satisfactory</ion-label>\n\n                <ion-radio value="Satisfactory" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Satisfactory</ion-label>\n\n                <ion-radio value="Not Satisfactory" select></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            4. Treated Decay:\n\n        </p>\n\n        <ion-item>\n\n            <ion-label>Select treated decay</ion-label>\n\n            <ion-select [(ngModel)]="treated" multiple>\n\n                <ion-option value="None">None</ion-option>\n\n                <ion-option value="Primary Only">Primary Only</ion-option>\n\n                <ion-option value="Primary and Permanent">Primary and Permanent</ion-option>\n\n                <ion-option value="Permanent Only">Permanent Only</ion-option>\n\n            </ion-select>\n\n        </ion-item>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            5. Presence of Dental Sealants:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="sealants" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Sealants</ion-label>\n\n                <ion-radio value="Sealants" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Satisfactory</ion-label>\n\n                <ion-radio value="No Sealants">No Sealants</ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            6. History of Rampant Caries?\n\n        </p>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:18px;">\n\n            (Delay on 7 or more teeth)\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="history" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Yes</ion-label>\n\n                <ion-radio value="Yes" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>No</ion-label>\n\n                <ion-radio value="No">No</ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            7. White Spot Lesions?\n\n        </p>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:80px; color:black; font-size:18px;">\n\n            (White spots on primary max. anteriors). Only Complete for children younger than 5 years of age.\n\n        </p>\n\n\n\n        <ion-list radio-group [(ngModel)]="white_spot" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Yes</ion-label>\n\n                <ion-radio value="Yes" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>No</ion-label>\n\n                <ion-radio value="No"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Applicable</ion-label>\n\n                <ion-radio value="Not Applicable"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            8. Age:\n\n        </p>\n\n        <ion-item>\n\n            <ion-label>Select age</ion-label>\n\n            <ion-select [(ngModel)]="age">\n\n\n\n                <ion-option value="0 to 11 Mo">0 to 11 Mo.</ion-option>\n\n                <ion-option value="1">1</ion-option>\n\n                <ion-option value="2">2</ion-option>\n\n                <ion-option value="3">3</ion-option>\n\n                <ion-option value="4">4</ion-option>\n\n                <ion-option value="5">5</ion-option>\n\n                <ion-option value="6">6</ion-option>\n\n                <ion-option value="7">7</ion-option>\n\n                <ion-option value="8">8</ion-option>\n\n                <ion-option value="9">9</ion-option>\n\n                <ion-option value="10">10</ion-option>\n\n                <ion-option value="11">11</ion-option>\n\n                <ion-option value="12">12</ion-option>\n\n                <ion-option value="13">13</ion-option>\n\n                <ion-option value="14">14</ion-option>\n\n                <ion-option value="15">15</ion-option>\n\n                <ion-option value="16">16</ion-option>\n\n                <ion-option value="17">17</ion-option>\n\n                <ion-option value="18">18</ion-option>\n\n\n\n            </ion-select>\n\n        </ion-item>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            9. Untreated Decay:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="untreated" margin-top>\n\n            <ion-item>\n\n                <ion-label>None</ion-label>\n\n                <ion-radio value="None" checked></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Primary Only</ion-label>\n\n                <ion-radio value="Primary Only"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Primary and Permanent</ion-label>\n\n                <ion-radio value="Primary and Permanent"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Permanent Only</ion-label>\n\n                <ion-radio value="Permanent Only"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            10. Treatment Urgency:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="treatment" margin-top>\n\n            <ion-item>\n\n                <ion-label>No Obvious Problem</ion-label>\n\n                <ion-radio value="No Obvious Problem" checked></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Early Dental Care</ion-label>\n\n                <ion-radio value="Early Dental Care"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Urgent Care</ion-label>\n\n                <ion-radio value="Urgent Care"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            11. Early Childhood Caries?\n\n        </p>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:80px; color:black; font-size:18px;">\n\n            (Caries history on primary max. anteriors). Only complete for children younger than 5 years of age.\n\n        </p>\n\n\n\n        <ion-list radio-group [(ngModel)]="childhood" margin-top>\n\n            <ion-item>\n\n                <ion-label>Yes</ion-label>\n\n                <ion-radio value="Yes" checked></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>No</ion-label>\n\n                <ion-radio value="No"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Applicable</ion-label>\n\n                <ion-radio value="Not Applicable"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n    </ion-card>\n\n\n\n    <ion-fab right bottom>\n\n        <button ion-fab color="dark" (click)="takePicture()">\n\n            <ion-icon name="md-camera"></ion-icon>\n\n        </button>\n\n    </ion-fab>\n\n\n\n    <button ion-button block color="dark" (click)="saveData()">Save Data</button>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\home\home.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */],
            __WEBPACK_IMPORTED_MODULE_2__ionic_native_camera__["a" /* Camera */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */],
            __WEBPACK_IMPORTED_MODULE_7__ionic_native_file_transfer__["a" /* FileTransfer */],
            __WEBPACK_IMPORTED_MODULE_3__ionic_native_sqlite__["a" /* SQLite */],
            __WEBPACK_IMPORTED_MODULE_4__ionic_storage__["b" /* Storage */],
            __WEBPACK_IMPORTED_MODULE_5__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_6__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_8__ionic_native_network__["a" /* Network */]])
    ], HomePage);
    return HomePage;
}());

//# sourceMappingURL=home.js.map

/***/ }),

/***/ 251:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MfilePageModule", function() { return MfilePageModule; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__mfile__ = __webpack_require__(252);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_file_upload__ = __webpack_require__(90);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var MfilePageModule = /** @class */ (function () {
    function MfilePageModule() {
    }
    MfilePageModule = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["I" /* NgModule */])({
            declarations: [
                __WEBPACK_IMPORTED_MODULE_2__mfile__["a" /* MfilePage */]
            ],
            imports: [
                __WEBPACK_IMPORTED_MODULE_3_ng2_file_upload__["a" /* FileUploadModule */],
                __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* IonicPageModule */].forChild(__WEBPACK_IMPORTED_MODULE_2__mfile__["a" /* MfilePage */])
            ]
        })
    ], MfilePageModule);
    return MfilePageModule;
}());

//# sourceMappingURL=mfile.module.js.map

/***/ }),

/***/ 252:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return MfilePage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ng2_file_upload__ = __webpack_require__(90);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_rxjs__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_userauth_userauth__ = __webpack_require__(17);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};




/**
 * Generated class for the MfilePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var MfilePage = /** @class */ (function () {
    function MfilePage(userAuth) {
        this.userAuth = userAuth;
        this.fileUploader = new __WEBPACK_IMPORTED_MODULE_1_ng2_file_upload__["b" /* FileUploader */]({});
        this.hasBaseDropZoneOver = false;
        this.regiData = new FormData;
    }
    MfilePage.prototype.ionViewDidLoad = function () {
        console.log('ionViewDidLoad MfilePage');
    };
    MfilePage.prototype.fileOverBase = function (event) {
        this.hasBaseDropZoneOver = event;
    };
    MfilePage.prototype.getFiles = function () {
        return this.fileUploader.queue.map(function (fileItem) {
            return fileItem.file;
        });
    };
    MfilePage.prototype.uploadFiles = function () {
        var _this = this;
        var files = this.getFiles();
        var requests = [];
        this.regiData.set('doc[]', '');
        files.forEach(function (file) {
            _this.regiData.append('doc[]', file.rawFile, file.name);
            //console.log(this.regiData);
        });
        requests.push(this.userAuth.uploadKycimg(this.regiData, 1));
        __WEBPACK_IMPORTED_MODULE_2_rxjs__["concat"].apply(void 0, requests).subscribe(function (res) {
            console.log(res);
        }, function (err) {
            console.log(err);
        });
    };
    MfilePage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-mfile',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\mfile\mfile.html"*/'<ion-header>\n\n    <ion-toolbar color="primary">\n\n        <ion-title>Upload Page</ion-title>\n\n    </ion-toolbar>\n\n</ion-header>\n\n\n\n<ion-content color="dark" padding>\n\n    <div ng2FileDrop [ngClass]="{\'drop-file-over\': hasBaseDropZoneOver}" (fileOver)="fileOverBase($event)" [uploader]="fileUploader"\n\n         class="area">\n\n        <div id="dropZone">Drop files here</div>\n\n    </div>\n\n\n\n\n\n    <input type="file" accept="image/*" ng2FileSelect [uploader]="fileUploader" multiple/>\n\n\n\n\n\n    <button (click)="uploadFiles()">Upload files</button>\n\n\n\n    <h2>Your files: {{ fileUploader?.queue?.length }}</h2>\n\n    <ul>\n\n        <li *ngFor="let item of fileUploader.queue">\n\n            {{ item?.file?.name }}\n\n        </li>\n\n    </ul>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\mfile\mfile.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_3__providers_userauth_userauth__["a" /* UserauthProvider */]])
    ], MfilePage);
    return MfilePage;
}());

//# sourceMappingURL=mfile.js.map

/***/ }),

/***/ 253:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UploadkycdocPageModule", function() { return UploadkycdocPageModule; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__uploadkycdoc__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_ng2_file_upload__ = __webpack_require__(90);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var UploadkycdocPageModule = /** @class */ (function () {
    function UploadkycdocPageModule() {
    }
    UploadkycdocPageModule = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["I" /* NgModule */])({
            declarations: [
                __WEBPACK_IMPORTED_MODULE_2__uploadkycdoc__["a" /* UploadKYCDocPage */]
            ],
            imports: [
                __WEBPACK_IMPORTED_MODULE_3_ng2_file_upload__["a" /* FileUploadModule */],
                __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["f" /* IonicPageModule */].forChild(__WEBPACK_IMPORTED_MODULE_2__uploadkycdoc__["a" /* UploadKYCDocPage */])
            ]
        })
    ], UploadkycdocPageModule);
    return UploadkycdocPageModule;
}());

//# sourceMappingURL=uploadkycdoc.module.js.map

/***/ }),

/***/ 295:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return NextPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_camera__ = __webpack_require__(141);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_sqlite__ = __webpack_require__(91);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ionic_native_file_transfer__ = __webpack_require__(92);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ionic_native_network__ = __webpack_require__(93);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__list_list__ = __webpack_require__(142);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









//import { ListPage } from "../list/list";
var NextPage = /** @class */ (function () {
    function NextPage(navCtrl, navParams, camera, menu, transfer, sqlite, util, userAuth, network) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.camera = camera;
        this.menu = menu;
        this.transfer = transfer;
        this.sqlite = sqlite;
        this.util = util;
        this.userAuth = userAuth;
        this.network = network;
        this.treated = [];
        this.data_treated = [];
        this.selectedItem = navParams.get('item');
        console.log('selected item', this.selectedItem);
        // this.screenDate=this.selectedItem.screening_date;
        // this.school_name=this.selectedItem.school_name;
        // this.screener_name=this.selectedItem.screener_name;
        this.selectedItem = this.navParams.get('item');
        //console.log('selected item', this.selectedItem);
        this.id = this.selectedItem.id;
        this.user_id = this.selectedItem.user_id;
        this.screenDate = this.selectedItem.screening_date;
        this.school_name = this.selectedItem.school_name;
        this.screener_name = this.selectedItem.screener_name;
        this.gender = this.selectedItem.gender;
        this.race = this.selectedItem.race;
        this.Hygiene = this.selectedItem.oral_hygiene;
        this.treated = this.selectedItem.treated_decay;
        this.treated = this.treated.split(",");
        console.log(this.treated);
        this.data_treated = [{ name: 'None', checked: this.isInData('None') },
            { name: 'Primary Only', checked: this.isInData('Primary Only') },
            { name: 'Primary and Permanent', checked: this.isInData('Primary and Permanent') },
            { name: 'Permanent Only', checked: this.isInData('Permanent Only') }
        ];
        this.sealants = this.selectedItem.presence;
        this.history = this.selectedItem.history_rampant_caries;
        this.white_spot = this.selectedItem.spot_lesions;
        this.age = this.selectedItem.age;
        this.untreated = this.selectedItem.untreated_decay;
        this.treatment = this.selectedItem.treatment_urgency;
        this.childhood = this.selectedItem.early_childhood_caries;
        this.imageData = this.selectedItem.image;
    }
    NextPage.prototype.selectMember = function (data) {
        if (data.checked == true) {
            this.treated.push(data.name);
        }
        else {
            var idx = this.treated.indexOf(data.name);
            this.treated.splice(idx, 1);
        }
        console.log(this.treated);
    };
    NextPage.prototype.ionViewDidEnter = function () {
        // this.selectedItem = this.navParams.get('item');
        // console.log('selected item', this.selectedItem);
        // this.screenDate=this.selectedItem.screening_date;
        // this.school_name=this.selectedItem.school_name;
        // this.screener_name=this.selectedItem.screener_name;
        // this.gender=this.selectedItem.gender;
        // this.race=this.selectedItem.race;
        // this.Hygiene=this.selectedItem.oral_hygiene;
        // this.treated=this.selectedItem.treated_decay;
        // this.sealants=this.selectedItem.presence;
        // this.history=this.selectedItem.history_rampant_caries;
        // this.white_spot=this.selectedItem.spot_lesions;
        // this.age=this.selectedItem.age;
        // this.untreated=this.selectedItem.untreated_decay;
        // this.treatment=this.selectedItem.treatment_urgency;
        // this.childhood=this.selectedItem.early_childhood_caries;
        //this.util.presentCustomToast("Untreated="+this.Hygiene);
    };
    //takePicture() {
    //  CameraPreview.takePicture({ maxWidth: 320, maxHeight: 320 });
    //}
    NextPage.prototype.takePicture = function () {
        var _this = this;
        var options = {
            quality: 100,
            destinationType: this.camera.DestinationType.FILE_URI,
            encodingType: this.camera.EncodingType.JPEG,
            mediaType: this.camera.MediaType.PICTURE
        };
        this.camera.getPicture(options).then(function (imageData) {
            console.log("imageData : ", imageData);
            _this.imageData = imageData;
        }, function (err) {
            // Handle error
            console.log("Camera image error", err);
        });
    };
    NextPage.prototype.saveData = function () {
        console.log("treated", this.treated);
        var treat_urgency = "";
        for (var i = 0; i < this.treated.length; i++) {
            treat_urgency += this.treated[i];
            if (i < this.treated.length - 1)
                treat_urgency += ",";
        }
        this.treated = treat_urgency;
        console.log("treated", this.treated);
        console.log("network connection type: ", this.network.type);
        console.log("image Data", this.imageData);
        console.log("Hygiene= " + this.Hygiene + "-" +
            this.sealants +
            "-" +
            this.history +
            "-" +
            this.white_spot +
            "-" +
            this.untreated +
            "-" +
            this.treatment +
            "-" +
            this.childhood);
        if (this.screenDate === "" || this.screenDate === "undefined") {
            this.util.presentCustomToast("Please select Screen Date");
        }
        else if (this.school_name === "" || this.school_name === "undefined") {
            this.util.presentCustomToast("Please Enter School Name");
        }
        else if (this.screener_name === "" ||
            this.screener_name === "undefined") {
            this.util.presentCustomToast("Please Enter Screener Name");
        }
        else if (this.gender === "" || this.gender === "undefined") {
            this.util.presentCustomToast("Please select your gender");
        }
        else if (this.race === "" || this.race === "undefined") {
            this.util.presentCustomToast("Please select your Race/Ethnicity.");
        }
        else if (this.Hygiene === "" || this.Hygiene === "undefined") {
            this.util.presentCustomToast("Please select your Oral Hygiene.");
        }
        else if (this.treated === "" || this.treated === "undefined") {
            this.util.presentCustomToast("Please select your Treated Decay.");
        }
        else if (this.sealants === "" || this.sealants === "undefined") {
            this.util.presentCustomToast("Please select your Presence of Dental Sealants.");
        }
        else if (this.history === "" || this.history === "undefined") {
            this.util.presentCustomToast("Please select your History of Rampant Caries?.");
        }
        else if (this.white_spot === "" || this.white_spot === "undefined") {
            this.util.presentCustomToast("Please select your White Spot Lesions?.");
        }
        else if (this.age === "" || this.age === "undefined") {
            this.util.presentCustomToast("Please select proper age.");
        }
        else if (this.untreated === "" || this.untreated === "undefined") {
            this.util.presentCustomToast("Please select Untreated Decay.");
        }
        else if (this.treatment === "" || this.treatment === "undefined") {
            this.util.presentCustomToast("Please select Treatment Urgency.");
        }
        else if (this.childhood === "" || this.childhood === "undefined") {
            this.util.presentCustomToast("Please select Early Childhood Caries?.");
        }
        else {
            if (this.network.type == "none")
                //this.save_data_offile();
                this.util.presentCustomToast("Network error, Could not update the data.");
            else
                this.uploadData();
        }
    };
    NextPage.prototype.logChosen = function () {
        console.log('fsdfdf');
    };
    NextPage.prototype.isInData = function (value) {
        console.log(this.treated.indexOf(value) > -1);
        return this.treated.indexOf(value) > -1;
    };
    NextPage.prototype.uploadData = function () {
        var _this = this;
        console.log('Image data: ', this.imageData);
        if (this.imageData) {
            var imagepath = this.imageData;
            this.util.presentLoading();
            //Update Image Data
            this.sqlite.create({
                name: 'datadb.db',
                location: 'default'
            }).then(function (db) {
                db.executeSql('UPDATE screendata SET image = "' + _this.imageData + '" where user_id="' + _this.user_id + '"', [])
                    .then(function (res) {
                    console.log('Offline data updated');
                })
                    .catch(function (e) { return console.log('Error in fetch query', e); });
            });
            //
            var fileTransfer = this.transfer.create();
            var options = {
                fileKey: "image",
                chunkedMode: false,
                mimeType: "multipart/form-data",
                headers: {},
                params: {
                    id: this.id,
                    user_id: this.user_id,
                    gender: this.gender,
                    race: this.race,
                    oral_hygiene: this.Hygiene,
                    treated_decay: this.treated,
                    presence: this.sealants,
                    history_rampant_caries: this.history,
                    spot_lesions: this.white_spot,
                    age: this.age,
                    untreated_decay: this.untreated,
                    treatment_urgency: this.treatment,
                    early_childhood_caries: this.childhood,
                    screening_date: this.screenDate,
                    school_name: this.school_name,
                    screener_name: this.screener_name,
                    image: this.imageData
                }
            };
            fileTransfer
                .upload(imagepath, "http://git.instaacoders.com/api/edit_data.php", options)
                .then(function (data) {
                var response = JSON.parse(data.response);
                // save response in storage
                _this.util.dismissLoading();
                _this.util.presentToast(response.message);
                console.log("response", response);
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_8__list_list__["a" /* ListPage */]);
            }, function (err) {
                console.log(err);
            });
        }
        else {
            this.uploadOnlyData();
        }
    };
    NextPage.prototype.uploadOnlyData = function () {
        var _this = this;
        var Data = new FormData;
        Data.append('user_id', this.user_id + "");
        Data.append('id', this.id + "");
        Data.append('gender', this.gender);
        Data.append('race', this.race);
        Data.append('oral_hygiene', this.Hygiene);
        Data.append('treated_decay', this.treated);
        Data.append('presence', this.sealants);
        Data.append('history_rampant_caries', this.history);
        Data.append('spot_lesions', this.white_spot);
        Data.append('age', this.age);
        Data.append('untreated_decay', this.untreated);
        Data.append('treatment_urgency', this.treatment);
        Data.append('early_childhood_caries', this.childhood);
        Data.append('screening_date', this.screenDate);
        Data.append('school_name', this.school_name);
        Data.append('screener_name', this.screener_name);
        //Data.append('image', this.imageData)
        this.util.presentLoading();
        this.userAuth.editData(Data).then(function (result) {
            console.log(result);
            _this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                _this.util.presentToast(result['message']);
            }
            else {
                _this.util.presentToast(result['message']);
            }
        });
    };
    NextPage.prototype.ionViewDidLoad = function () {
        console.log("ionViewDidLoad NextPage");
    };
    NextPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: "page-next",template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\next\next.html"*/'<!--\n\n  Generated template for the NextPage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n\n\n    <ion-navbar color="dark">\n\n        <button ion-button menuToggle>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>Asuun Document Management</ion-title>\n\n        <!--<ion-buttons end>\n\n      <button ion-button icon-only (click)="save()"><ion-icon name="send"></ion-icon></button>\n\n    </ion-buttons>-->\n\n    </ion-navbar>\n\n\n\n</ion-header>\n\n\n\n\n\n<ion-content padding="true" style="background-color:#fffee4;">\n\n    <h3 text-wrap style="color:black; font-size:20px; font-weight:bold; line-height:1;">Preventive Services Program (PSP) Survey</h3>\n\n\n\n    <ion-row style="background-color:black; border:thin;">\n\n\n\n        <ion-col width-70>\n\n            <!-- <ion-input type="number" style="background-color:#fffee4; font-size:12px;" [(ngModel)]="screenDate"> </ion-input> -->\n\n            <ion-datetime style="background-color:#fffee4; font-size:12px;" displayFormat="YYYY/MM/DD" [(ngModel)]="screenDate"\n\n                          placeholder="Screening Date:"></ion-datetime>\n\n        </ion-col>\n\n        <ion-col width-70>\n\n            <ion-input type="text" style="background-color:#fffee4; font-size:12px;" [(ngModel)]="school_name"></ion-input>\n\n        </ion-col>\n\n        <ion-col width-70>\n\n            <ion-input type="text" style="background-color:#fffee4; font-size:12px;" [(ngModel)]="screener_name"></ion-input>\n\n        </ion-col>\n\n    </ion-row>\n\n    <ion-card style="background-color:#fffee4; margin-top:10px;">\n\n        <h3 style="color:black; font-size:18px; ">DO NOT LEAVE ANY QUESTIONS UNANSWERED</h3>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            1. Gender:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="gender">\n\n\n\n            <ion-item>\n\n                <ion-label>Male</ion-label>\n\n                <ion-radio value="male" [checked]="gender===\'male\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Female</ion-label>\n\n                <ion-radio value="female" [checked]="gender===\'female\'"></ion-radio>\n\n            </ion-item>\n\n\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            2. Race/Ethnicity:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="race" margin-top>\n\n            <ion-item>\n\n                <ion-label>White</ion-label>\n\n                <ion-radio value="White" [checked]="race===\'White\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>African-American</ion-label>\n\n                <ion-radio value="African-American" [checked]="race===\'African-American\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Asian or Pacific Islander</ion-label>\n\n                <ion-radio value="Asian or Pacific Islander" [checked]="race===\'Asian or Pacific Islander\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>American Indian</ion-label>\n\n                <ion-radio value="American Indian" [checked]="race===\'American Indian\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Multi-Racial</ion-label>\n\n                <ion-radio value="Multi-Racial" [checked]="race===\'Multi-Racial\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Unknown (Non White)</ion-label>\n\n                <ion-radio value="Unknown (Non White)" [checked]="race===\'Unknown (Non White)\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Hispanic</ion-label>\n\n                <ion-radio value="Hispanic" [checked]="race===\'Hispanic\'"></ion-radio>\n\n            </ion-item>\n\n\n\n\n\n        </ion-list>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            3. Oral Hygiene:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="Hygiene" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Satisfactory</ion-label>\n\n                <ion-radio value="Satisfactory" [checked]="Hygiene===\'Satisfactory\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Satisfactory</ion-label>\n\n                <ion-radio value="Not Satisfactory" [checked]="Hygiene===\'Not Satisfactory\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            4. Treated Decay:\n\n        </p>\n\n\n\n\n\n        <div *ngIf="data_treated.length > 0">\n\n            <ion-item *ngFor="let member of data_treated">\n\n                <ion-label>{{member?.name || \'N/A\'}}</ion-label>\n\n                <ion-checkbox color="dark" (click)="selectMember(member)" [(ngModel)]="member.checked"></ion-checkbox>\n\n            </ion-item>\n\n        </div>\n\n        <!-- <ion-select [(ngModel)]="treated" multiple (ionChange)="logChosen()">\n\n           <ion-option *ngFor="let t of data_treated" value="t">{{t}}</ion-option> -->\n\n        <!-- <ion-option value="None" selected="selected">None</ion-option>\n\n       <ion-option value="Primary Only" selected="selected">Primary Only</ion-option>\n\n       <ion-option value="Primary and Permanent" selected="inArray(\'Primary and Permanent\')">Primary and Permanent</ion-option>\n\n       <ion-option value="Permanent Only" selected="inArray(\'Permanent Only\')">Permanent Only</ion-option>  -->\n\n        <!-- </ion-select>  -->\n\n        <!-- <ion-checkbox *ngFor="let member of data_treated" [(ngModel)]="treated">{{member}}</ion-checkbox> -->\n\n\n\n\n\n        <!-- <ion-list radio-group [(ngModel)]="treated" margin-top>\n\n            <ion-item>\n\n                <ion-label>None</ion-label>\n\n                <ion-radio value="None" [checked]="treated===\'None\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Primary Only</ion-label>\n\n                <ion-radio value="Primary Only" [checked]="treated===\'Primary Only\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Primary and Permanent</ion-label>\n\n                <ion-radio value="Primary and Permanent" [checked]="treated===\'Primary and Permanent\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Permanent Only</ion-label>\n\n                <ion-radio value="Permanent Only" [checked]="treated===\'Permanent Only\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list> -->\n\n\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            5. Presence of Dental Sealants:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="sealants" margin-top>\n\n            <ion-item>\n\n                <ion-label>Sealants</ion-label>\n\n                <ion-radio value="Sealants" [checked]="sealants===\'Sealants\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Satisfactory</ion-label>\n\n                <ion-radio value="No Sealants" [checked]="sealants===\'No Sealants\'">No Sealants</ion-radio>\n\n            </ion-item>\n\n        </ion-list>\n\n\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            6. History of Rampant Caries?\n\n        </p>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:18px;">\n\n            (Delay on 7 or more teeth)\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="history" margin-top>\n\n            <ion-item>\n\n                <ion-label>Yes</ion-label>\n\n                <ion-radio value="Yes" [checked]="history===\'Yes\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>No</ion-label>\n\n                <ion-radio value="No" [checked]="history===\'No\'">No</ion-radio>\n\n            </ion-item>\n\n\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            7. White Spot Lesions?\n\n        </p>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:80px; color:black; font-size:18px;">\n\n            (White spots on primary max. anteriors). Only Complete for children younger than 5 years of age.\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="white_spot" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Yes</ion-label>\n\n                <ion-radio value="Yes" [checked]="white_spot===\'Yes\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>No</ion-label>\n\n                <ion-radio value="No" [checked]="white_spot===\'No\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Applicable</ion-label>\n\n                <ion-radio value="Not Applicable" [checked]="white_spot===\'Not Applicable\'"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            8. Age:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="age" margin-top>\n\n            <ion-item>\n\n                <ion-label>0 to 11 Mo.</ion-label>\n\n                <ion-radio value="0 to 11 Mo." [checked]="age===\'0 to 11 Mo.\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>1</ion-label>\n\n                <ion-radio value="1" [checked]="age===\'1\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>2</ion-label>\n\n                <ion-radio value="2" [checked]="age===\'2\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>3</ion-label>\n\n                <ion-radio value="3" [checked]="age===\'3\'"></ion-radio>\n\n            </ion-item>\n\n            <ion-item>\n\n                <ion-label>4</ion-label>\n\n                <ion-radio value="4" [checked]="age===\'4\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>5</ion-label>\n\n                <ion-radio value="5" [checked]="age===\'5\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>6</ion-label>\n\n                <ion-radio value="6" [checked]="age===\'6\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>7</ion-label>\n\n                <ion-radio value="7" [checked]="age===\'7\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>8</ion-label>\n\n                <ion-radio value="8" [checked]="age===\'8\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>9</ion-label>\n\n                <ion-radio value="9" [checked]="age===\'9\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>10</ion-label>\n\n                <ion-radio value="10" [checked]="age===\'10\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>11</ion-label>\n\n                <ion-radio value="11" [checked]="age===\'11\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>12</ion-label>\n\n                <ion-radio value="12" [checked]="age===\'12\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>13</ion-label>\n\n                <ion-radio value="13" [checked]="age===\'13\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>14</ion-label>\n\n                <ion-radio value="14" [checked]="age===\'14\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>15</ion-label>\n\n                <ion-radio value="15" [checked]="age===\'15\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>16</ion-label>\n\n                <ion-radio value="16" [checked]="age===\'16\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>17</ion-label>\n\n                <ion-radio value="17" [checked]="age===\'17\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>18</ion-label>\n\n                <ion-radio value="18" [checked]="age===\'18\'"></ion-radio>\n\n            </ion-item>\n\n        </ion-list>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            9. Untreated Decay:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="untreated" margin-top>\n\n            <ion-item>\n\n                <ion-label>None</ion-label>\n\n                <ion-radio value="None" [checked]="untreated===\'None\'" checked></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Primary Only</ion-label>\n\n                <ion-radio value="Primary Only" [checked]="untreated===\'Primary Only\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Primary and Permanent</ion-label>\n\n                <ion-radio value="Primary and Permanent" [checked]="untreated===\'Primary and Permanent\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Permanent Only</ion-label>\n\n                <ion-radio value="Permanent Only" [checked]="untreated===\'Permanent Only\'"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:30px; color:black; font-size:19px; font-weight:bold;">\n\n            10. Treatment Urgency:\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="treatment" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>No Obvious Problem</ion-label>\n\n                <ion-radio value="No Obvious Problem" [checked]="treatment===\'No Obvious Problem\'" select></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Early Dental Care</ion-label>\n\n                <ion-radio value="Early Dental Care" [checked]="treatment===\'Early Dental Care\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Urgent Care</ion-label>\n\n                <ion-radio value="Urgent Care" [checked]="treatment===\'Urgent Care\'"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:20px; color:black; font-size:19px; font-weight:bold;">\n\n            11. Early Childhood Caries?\n\n        </p>\n\n        <p style="text-align:initial; background-color:#fffee4; margin-left:2px; height:80px; color:black; font-size:18px;">\n\n            (Caries history on primary max. anteriors). Only complete for children younger than 5 years of age.\n\n        </p>\n\n        <ion-list radio-group [(ngModel)]="childhood" margin-top>\n\n\n\n            <ion-item>\n\n                <ion-label>Yes</ion-label>\n\n                <ion-radio value="Yes" [checked]="childhood===\'Yes\'" checked></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>No</ion-label>\n\n                <ion-radio value="No" [checked]="childhood===\'No\'"></ion-radio>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label>Not Applicable</ion-label>\n\n                <ion-radio value="Not Applicable" [checked]="childhood===\'Not Applicable\'"></ion-radio>\n\n            </ion-item>\n\n\n\n        </ion-list>\n\n\n\n    </ion-card>\n\n    <ion-fab right bottom>\n\n        <button ion-fab color="dark" (click)="takePicture()">\n\n            <ion-icon name="md-camera"></ion-icon>\n\n        </button>\n\n        <!--<img [src]="base64Image" *ngIf="base64Image" />-->\n\n    </ion-fab>\n\n    <!--<button ion-button color="dark" click="takephoto()">\n\n    <ion-icon name="camera"></ion-icon>&nbsp;\n\n    Take a photo\n\n  </button>-->\n\n\n\n\n\n    <button ion-button block color="dark" (click)="saveData()">Update data</button>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\next\next.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */],
            __WEBPACK_IMPORTED_MODULE_2__ionic_native_camera__["a" /* Camera */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */],
            __WEBPACK_IMPORTED_MODULE_6__ionic_native_file_transfer__["a" /* FileTransfer */],
            __WEBPACK_IMPORTED_MODULE_3__ionic_native_sqlite__["a" /* SQLite */],
            __WEBPACK_IMPORTED_MODULE_4__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_5__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_7__ionic_native_network__["a" /* Network */]])
    ], NextPage);
    return NextPage;
}());

//# sourceMappingURL=next.js.map

/***/ }),

/***/ 297:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return KycProvider; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_common_http__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_core__ = __webpack_require__(0);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


/*
  Generated class for the KycProvider provider.

  See https://angular.io/guide/dependency-injection for more info on providers
  and Angular DI.
*/
var KycProvider = /** @class */ (function () {
    function KycProvider(http) {
        this.http = http;
        console.log('Hello KycProvider Provider');
    }
    KycProvider = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_1__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_0__angular_common_http__["b" /* HttpClient */]])
    ], KycProvider);
    return KycProvider;
}());

//# sourceMappingURL=kyc.js.map

/***/ }),

/***/ 298:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FbloginPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__uploadkycdoc_uploadkycdoc__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__showuserans_showuserans__ = __webpack_require__(56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__ionic_native_facebook__ = __webpack_require__(88);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};








/**
 * Generated class for the FbloginPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var FbloginPage = /** @class */ (function () {
    function FbloginPage(fb, navCtrl, navParams, userAuth, menu, storage, util) {
        this.fb = fb;
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.menu = menu;
        this.storage = storage;
        this.util = util;
        this.isLoggedIn = false;
    }
    FbloginPage.prototype.loginAction = function () {
        var _this = this;
        // Login with permissions
        this.fb.login(['public_profile', 'email'])
            .then(function (res) {
            // The connection was successful
            if (res.status == "connected") {
                _this.isLoggedIn = true;
                _this.getUserDetail(res.authResponse.userID);
                // Get user ID and Token
                //var fb_id = res.authResponse.userID;
                //var fb_token = res.authResponse.accessToken;
            }
            else {
                console.log("An error occurred...");
            }
        })
            .catch(function (e) {
            console.log('Error logging into Facebook', e);
        });
    };
    FbloginPage.prototype.getUserDetail = function (userid) {
        var _this = this;
        this.fb.api("/" + userid + "/?fields=id,email,name,picture", ["public_profile"])
            .then(function (res) {
            console.log(res);
            _this.users = res;
            _this.uname = res.name;
            _this.uemail = res.email;
            _this.userAuth.fblogin(_this.uname, _this.uemail).then(function (result) {
                // console.log(result);
                _this.util.dismissLoading();
                if (result['success'] && result['ltype'] == '0' || result['ltype'] == '1') {
                    //Display sucess Toast
                    _this.util.presentToast(result['message']);
                    _this.storage.set('isLogin', true);
                    _this.storage.set('user_id', result['userId']);
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__uploadkycdoc_uploadkycdoc__["a" /* UploadKYCDocPage */]);
                }
                else if (result['success'] && result['ltype'] == '2') {
                    _this.storage.set('user_id', result['userId']);
                    _this.util.presentToast(result['message']);
                    _this.storage.set('isLogin', true);
                    _this.menu.enable(true);
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_6__showuserans_showuserans__["a" /* ShowuseransPage */]);
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        })
            .catch(function (e) {
            console.log(e);
        });
    };
    FbloginPage.prototype.logout = function () {
        var _this = this;
        this.fb.logout()
            .then(function (res) { return _this.isLoggedIn = false; })
            .catch(function (e) { return console.log('Error logout from Facebook', e); });
    };
    FbloginPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-fblogin',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\fblogin\fblogin.html"*/'<ion-header>\n\n    <ion-navbar>\n\n        <ion-title>\n\n            Facebook Login\n\n        </ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n<!-- <ion-content padding>\n\n  <div class="intro">\n\n      Tap the button below to log-in with Facebook\n\n  </div>\n\n  <div class="btn_container">\n\n      <button ion-button full (click)="loginAction();">Login with Facebook</button>\n\n\n\n      <div *ngIf="name">\n\n        Name: {{name}}\n\n      </div>\n\n\n\n  </div>\n\n</ion-content>  -->\n\n\n\n\n\n<ion-content padding>\n\n    <div *ngIf="isLoggedIn; else facebookLogin">\n\n\n\n        <p>\n\n            <button ion-button icon-right (click)="logout()">\n\n                Logout\n\n            </button>\n\n        </p>\n\n    </div>\n\n    <ng-template #facebookLogin>\n\n        <button ion-button icon-right (click)="loginAction()">\n\n            Login with\n\n            <ion-icon name="logo-facebook"></ion-icon>\n\n        </button>\n\n    </ng-template>\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\fblogin\fblogin.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_7__ionic_native_facebook__["a" /* Facebook */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_3__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_4__providers_util_util__["a" /* UtilProvider */]])
    ], FbloginPage);
    return FbloginPage;
}());

//# sourceMappingURL=fblogin.js.map

/***/ }),

/***/ 299:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return SocialLogin; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__auth0_angular_jwt__ = __webpack_require__(460);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};


var SocialLogin = /** @class */ (function () {
    function SocialLogin(ngZone) {
        this.ngZone = ngZone;
        this.NAME_SCOPE = 0;
        this.EMAIL_SCOPE = 1;
        this.jwtHelper = new __WEBPACK_IMPORTED_MODULE_1__auth0_angular_jwt__["a" /* JwtHelperService */]();
    }
    /**
     * Wrapping Cordova plugin to be used in Ionic/Angular.
     */
    SocialLogin.prototype.cordovaAppleSignIn = function () {
        var _this = this;
        var options = { requestedScopes: [this.NAME_SCOPE, this.EMAIL_SCOPE] };
        return new Promise(function (resolve, reject) {
            cordova.plugins.SignInWithApple.signin(options, function (data) {
                console.log(JSON.stringify(data));
                // "Sign in with Apple" gives the email only first time
                if (!data.email) {
                    // So decode the AWT token and extract the email from it
                    var decodedToken = _this.jwtHelper.decodeToken(data.identityToken);
                    data.email = decodedToken.email;
                }
                resolve(data);
            }, function (err) {
                console.log(JSON.stringify(err));
                _this.ngZone.run(function () {
                    reject(err);
                });
            });
        });
    };
    SocialLogin = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["A" /* Injectable */])(),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_0__angular_core__["M" /* NgZone */]])
    ], SocialLogin);
    return SocialLogin;
}());

//# sourceMappingURL=social-login.js.map

/***/ }),

/***/ 300:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LoginFingerPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_fingerprint_aio__ = __webpack_require__(249);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__home_home__ = __webpack_require__(250);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__ionic_storage__ = __webpack_require__(19);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Generated class for the LoginFingerPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var LoginFingerPage = /** @class */ (function () {
    function LoginFingerPage(navCtrl, navParams, menu, util, userAuth, storage, faio, platform) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.menu = menu;
        this.util = util;
        this.userAuth = userAuth;
        this.storage = storage;
        this.faio = faio;
        this.platform = platform;
        this.login();
    }
    LoginFingerPage.prototype.ionViewDidLoad = function () {
        console.log('ionViewDidLoad LoginFingerPage');
    };
    LoginFingerPage.prototype.login = function () {
        var _this = this;
        this.fingerprintOptions = {
            clientId: 'fingerprint-Demo',
            clientSecret: 'password',
            disableBackup: false,
            localizedFallbackTitle: ''
        };
        this.faio.isAvailable().then(function (result) {
            if (result === "finger") {
                _this.faio.show(_this.fingerprintOptions)
                    .then(function (result) {
                    if (result.withFingerprint) {
                        console.log('Successfully encrypted credentials.');
                        console.log('Encrypted credentials: ' + result.withFingerprint);
                        _this.util.presentToast('Fingerprint register');
                        _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_3__home_home__["a" /* HomePage */]);
                    }
                    else if (result.withPassword) {
                        console.log('Successfully authenticated with backup password!');
                        _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_3__home_home__["a" /* HomePage */]);
                    }
                    else {
                        console.log('Didn\'t authenticate!');
                        _this.util.presentToast('Fingerprint unautherised');
                    }
                })
                    .catch(function (error) {
                    if (error.message == 'Cancelled') {
                        _this.util.presentToast(error.message);
                        _this.platform.exitApp();
                    }
                    else {
                        _this.util.presentToast(error.message);
                        _this.platform.exitApp();
                    }
                });
            }
            else {
                debugger;
            }
        })
            .catch(function (error) {
            if (error.message == 'Fingerprint authentication not ready') {
                _this.util.presentToast(error.message);
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_3__home_home__["a" /* HomePage */]);
            }
            else {
                _this.util.presentToast(error.message);
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_3__home_home__["a" /* HomePage */]);
            }
        });
    };
    LoginFingerPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-login-finger',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\login-finger\login-finger.html"*/'<ion-content>\n\n    <div padding-horizontal text-center class="animated fadeInDown">\n\n        <img class="logo" src="assets/imgs/front.png">\n\n        <br>\n\n        <span style="font-size: 20px; "><strong>Asuun</strong></span>\n\n        <br>\n\n        <span style="font-size: 16px; ">Document Management System</span>\n\n    </div>\n\n    <!-- <ion-row class="login-row" align-items-center>\n\n\n\n      <ion-col>\n\n          <img src="assets/imgs/fingerprint.png" class="lock-img" style="    width: 100px;" tappable (click)="login()">\n\n\n\n      </ion-col>\n\n\n\n\n\n    </ion-row>\n\n    <ion-row>\n\n        <ion-col>\n\n            <div class="center blinking">\n\n                <p><b>Note: </b>Using margin:auto will not work in IE8, unless a !DOCTYPE is declared.</p>\n\n              </div>\n\n        </ion-col>\n\n    </ion-row> -->\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\login-finger\login-finger.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */],
            __WEBPACK_IMPORTED_MODULE_4__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_5__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_6__ionic_storage__["b" /* Storage */],
            __WEBPACK_IMPORTED_MODULE_2__ionic_native_fingerprint_aio__["a" /* FingerprintAIO */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["l" /* Platform */]])
    ], LoginFingerPage);
    return LoginFingerPage;
}());

//# sourceMappingURL=login-finger.js.map

/***/ }),

/***/ 301:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_platform_browser_dynamic__ = __webpack_require__(302);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__app_module__ = __webpack_require__(421);


Object(__WEBPACK_IMPORTED_MODULE_0__angular_platform_browser_dynamic__["a" /* platformBrowserDynamic */])().bootstrapModule(__WEBPACK_IMPORTED_MODULE_1__app_module__["a" /* AppModule */]);
//# sourceMappingURL=main.js.map

/***/ }),

/***/ 421:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AppModule; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__pages_next_next__ = __webpack_require__(295);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__ = __webpack_require__(44);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_facebook__ = __webpack_require__(88);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__pages_register_register__ = __webpack_require__(164);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__app_component__ = __webpack_require__(485);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__pages_home_home__ = __webpack_require__(250);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__pages_list_list__ = __webpack_require__(142);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__pages_uploadkycdoc_uploadkycdoc__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__ionic_native_status_bar__ = __webpack_require__(293);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__ionic_native_splash_screen__ = __webpack_require__(294);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__ionic_native_camera__ = __webpack_require__(141);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__angular_common_http__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17__ionic_native_sqlite__ = __webpack_require__(91);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__ionic_native_file_transfer__ = __webpack_require__(92);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19__ionic_native_file_path__ = __webpack_require__(486);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20__ionic_native_network__ = __webpack_require__(93);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21__ionic_native_fingerprint_aio__ = __webpack_require__(249);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22__ionic_native_file_ngx__ = __webpack_require__(487);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23__pages_login_finger_login_finger__ = __webpack_require__(300);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24__pages_showquestions_showquestions__ = __webpack_require__(165);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25__pages_mfile_mfile__ = __webpack_require__(252);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26__pages_showuserans_showuserans__ = __webpack_require__(56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27__pages_userdeavtive_userdeavtive__ = __webpack_require__(166);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28__pages_viewprofile_viewprofile__ = __webpack_require__(98);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_29__providers_kyc_kyc__ = __webpack_require__(297);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_30__pages_editprofile_editprofile__ = __webpack_require__(167);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_31__pages_editdocs_editdocs__ = __webpack_require__(168);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_32__pages_fblogin_fblogin__ = __webpack_require__(298);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_33__pages_otpverification_otpverification__ = __webpack_require__(55);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_34__pages_mfile_mfile_module__ = __webpack_require__(251);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_35__pages_uploadkycdoc_uploadkycdoc_module__ = __webpack_require__(253);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




































var AppModule = /** @class */ (function () {
    function AppModule() {
    }
    AppModule = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_2__angular_core__["I" /* NgModule */])({
            declarations: [
                __WEBPACK_IMPORTED_MODULE_6__app_component__["a" /* MyApp */],
                __WEBPACK_IMPORTED_MODULE_7__pages_home_home__["a" /* HomePage */],
                __WEBPACK_IMPORTED_MODULE_8__pages_list_list__["a" /* ListPage */],
                __WEBPACK_IMPORTED_MODULE_0__pages_next_next__["a" /* NextPage */],
                __WEBPACK_IMPORTED_MODULE_5__pages_register_register__["a" /* RegistrationPage */],
                __WEBPACK_IMPORTED_MODULE_23__pages_login_finger_login_finger__["a" /* LoginFingerPage */],
                __WEBPACK_IMPORTED_MODULE_24__pages_showquestions_showquestions__["a" /* ShowquestionsPage */],
                __WEBPACK_IMPORTED_MODULE_26__pages_showuserans_showuserans__["a" /* ShowuseransPage */],
                __WEBPACK_IMPORTED_MODULE_28__pages_viewprofile_viewprofile__["a" /* ViewprofilePage */],
                __WEBPACK_IMPORTED_MODULE_30__pages_editprofile_editprofile__["a" /* EditprofilePage */],
                __WEBPACK_IMPORTED_MODULE_31__pages_editdocs_editdocs__["a" /* EditdocsPage */],
                __WEBPACK_IMPORTED_MODULE_32__pages_fblogin_fblogin__["a" /* FbloginPage */],
                __WEBPACK_IMPORTED_MODULE_27__pages_userdeavtive_userdeavtive__["a" /* UserdeavtivePage */],
                __WEBPACK_IMPORTED_MODULE_33__pages_otpverification_otpverification__["a" /* OtpverificationPage */]
            ],
            imports: [
                __WEBPACK_IMPORTED_MODULE_1__angular_platform_browser__["a" /* BrowserModule */],
                __WEBPACK_IMPORTED_MODULE_14__angular_common_http__["c" /* HttpClientModule */],
                __WEBPACK_IMPORTED_MODULE_34__pages_mfile_mfile_module__["MfilePageModule"],
                __WEBPACK_IMPORTED_MODULE_35__pages_uploadkycdoc_uploadkycdoc_module__["UploadkycdocPageModule"],
                __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["e" /* IonicModule */].forRoot(__WEBPACK_IMPORTED_MODULE_6__app_component__["a" /* MyApp */], {}, {
                    links: [
                        { loadChildren: '../pages/add-kyc/add-kyc.module#AddKycPageModule', name: 'AddKycPage', segment: 'add-kyc', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/detail/detail.module#DetailPageModule', name: 'DetailPage', segment: 'detail', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/fblogin/fblogin.module#FbloginPageModule', name: 'FbloginPage', segment: 'fblogin', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/login-finger/login-finger.module#LoginFingerPageModule', name: 'LoginFingerPage', segment: 'login-finger', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/editprofile/editprofile.module#EditprofilePageModule', name: 'EditprofilePage', segment: 'editprofile', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/mfile/mfile.module#MfilePageModule', name: 'MfilePage', segment: 'mfile', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/register/register.module#RegistrationPageModule', name: 'RegistrationPage', segment: 'register', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/showquestions/showquestions.module#ShowquestionsPageModule', name: 'ShowquestionsPage', segment: 'showquestions', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/showuserans/showuserans.module#ShowuseransPageModule', name: 'ShowuseransPage', segment: 'showuserans', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/sidemenu/sidemenu.module#SidemenuPageModule', name: 'SidemenuPage', segment: 'sidemenu', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/otpverification/otpverification.module#OtpverificationPageModule', name: 'OtpverificationPage', segment: 'otpverification', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/userdeavtive/userdeavtive.module#UserdeavtivePageModule', name: 'UserdeavtivePage', segment: 'userdeavtive', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/editdocs/editdocs.module#EditdocsPageModule', name: 'EditdocsPage', segment: 'editdocs', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/login/login.module#LoginPageModule', name: 'LoginPage', segment: 'login', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/uploadkycdoc/uploadkycdoc.module#UploadkycdocPageModule', name: 'UploadKYCDocPage', segment: 'uploadkycdoc', priority: 'low', defaultHistory: [] },
                        { loadChildren: '../pages/viewprofile/viewprofile.module#ViewprofilePageModule', name: 'ViewprofilePage', segment: 'viewprofile', priority: 'low', defaultHistory: [] }
                    ]
                }),
                __WEBPACK_IMPORTED_MODULE_16__ionic_storage__["a" /* IonicStorageModule */].forRoot()
            ],
            bootstrap: [__WEBPACK_IMPORTED_MODULE_4_ionic_angular__["c" /* IonicApp */]],
            entryComponents: [
                __WEBPACK_IMPORTED_MODULE_6__app_component__["a" /* MyApp */],
                __WEBPACK_IMPORTED_MODULE_7__pages_home_home__["a" /* HomePage */],
                __WEBPACK_IMPORTED_MODULE_8__pages_list_list__["a" /* ListPage */],
                __WEBPACK_IMPORTED_MODULE_0__pages_next_next__["a" /* NextPage */],
                __WEBPACK_IMPORTED_MODULE_5__pages_register_register__["a" /* RegistrationPage */],
                __WEBPACK_IMPORTED_MODULE_23__pages_login_finger_login_finger__["a" /* LoginFingerPage */],
                __WEBPACK_IMPORTED_MODULE_24__pages_showquestions_showquestions__["a" /* ShowquestionsPage */],
                __WEBPACK_IMPORTED_MODULE_26__pages_showuserans_showuserans__["a" /* ShowuseransPage */],
                __WEBPACK_IMPORTED_MODULE_28__pages_viewprofile_viewprofile__["a" /* ViewprofilePage */],
                __WEBPACK_IMPORTED_MODULE_9__pages_uploadkycdoc_uploadkycdoc__["a" /* UploadKYCDocPage */],
                __WEBPACK_IMPORTED_MODULE_30__pages_editprofile_editprofile__["a" /* EditprofilePage */],
                __WEBPACK_IMPORTED_MODULE_31__pages_editdocs_editdocs__["a" /* EditdocsPage */],
                __WEBPACK_IMPORTED_MODULE_32__pages_fblogin_fblogin__["a" /* FbloginPage */],
                __WEBPACK_IMPORTED_MODULE_27__pages_userdeavtive_userdeavtive__["a" /* UserdeavtivePage */],
                __WEBPACK_IMPORTED_MODULE_25__pages_mfile_mfile__["a" /* MfilePage */],
                __WEBPACK_IMPORTED_MODULE_33__pages_otpverification_otpverification__["a" /* OtpverificationPage */]
            ],
            providers: [
                __WEBPACK_IMPORTED_MODULE_10__ionic_native_status_bar__["a" /* StatusBar */],
                __WEBPACK_IMPORTED_MODULE_11__ionic_native_splash_screen__["a" /* SplashScreen */],
                __WEBPACK_IMPORTED_MODULE_12__ionic_native_camera__["a" /* Camera */],
                __WEBPACK_IMPORTED_MODULE_17__ionic_native_sqlite__["a" /* SQLite */],
                __WEBPACK_IMPORTED_MODULE_18__ionic_native_file_transfer__["a" /* FileTransfer */],
                __WEBPACK_IMPORTED_MODULE_19__ionic_native_file_path__["a" /* FilePath */],
                __WEBPACK_IMPORTED_MODULE_20__ionic_native_network__["a" /* Network */],
                { provide: __WEBPACK_IMPORTED_MODULE_2__angular_core__["u" /* ErrorHandler */], useClass: __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["d" /* IonicErrorHandler */] },
                __WEBPACK_IMPORTED_MODULE_3__ionic_native_facebook__["a" /* Facebook */],
                __WEBPACK_IMPORTED_MODULE_13__providers_userauth_userauth__["a" /* UserauthProvider */],
                __WEBPACK_IMPORTED_MODULE_15__providers_util_util__["a" /* UtilProvider */],
                __WEBPACK_IMPORTED_MODULE_21__ionic_native_fingerprint_aio__["a" /* FingerprintAIO */],
                __WEBPACK_IMPORTED_MODULE_22__ionic_native_file_ngx__["a" /* File */],
                __WEBPACK_IMPORTED_MODULE_29__providers_kyc_kyc__["a" /* KycProvider */]
            ]
        })
    ], AppModule);
    return AppModule;
}());

//# sourceMappingURL=app.module.js.map

/***/ }),

/***/ 485:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return MyApp; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_native_status_bar__ = __webpack_require__(293);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__ionic_native_splash_screen__ = __webpack_require__(294);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__pages_login_login__ = __webpack_require__(73);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__pages_viewprofile_viewprofile__ = __webpack_require__(98);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__pages_showuserans_showuserans__ = __webpack_require__(56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__ionic_native_facebook__ = __webpack_require__(88);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};









var MyApp = /** @class */ (function () {
    function MyApp(fb, platform, statusBar, splashScreen, storage) {
        this.fb = fb;
        this.platform = platform;
        this.statusBar = statusBar;
        this.splashScreen = splashScreen;
        this.storage = storage;
        this.rootPage = 'LoginPage';
        this.initializeApp();
        // used for an example of ngFor and navigation
        this.pages = [
            { title: 'View Profile', component: __WEBPACK_IMPORTED_MODULE_6__pages_viewprofile_viewprofile__["a" /* ViewprofilePage */] },
            { title: 'Sign out', component: 'signout' }
        ];
    }
    MyApp.prototype.initializeApp = function () {
        var _this = this;
        this.platform.ready().then(function () {
            // Okay, so the platform is ready and our plugins are available.
            // Here you can do any higher level native things you might need.
            //this.statusBar.styleDefault();
            _this.storage.get('isLogin').then(function (value) {
                console.log('Login status', value);
                //if(value) this.rootPage = LoginFingerPage
                if (value)
                    _this.rootPage = __WEBPACK_IMPORTED_MODULE_7__pages_showuserans_showuserans__["a" /* ShowuseransPage */];
            });
            _this.statusBar.backgroundColorByHexString('secondary');
            _this.splashScreen.hide();
        });
    };
    MyApp.prototype.openPage = function (page) {
        // Reset the content nav to have just this page
        // we wouldn't want the back button to show in this scenario
        if (page.component == 'signout') {
            this.fb.logout();
            this.storage.set('isLogin', false);
            this.storage.remove('user_id');
            //this.rootPage = LoginPage
            this.nav.setRoot(__WEBPACK_IMPORTED_MODULE_5__pages_login_login__["a" /* LoginPage */]);
        }
        else {
            this.nav.setRoot(page.component);
        }
    };
    __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["_8" /* ViewChild */])(__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["i" /* Nav */]),
        __metadata("design:type", __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["i" /* Nav */])
    ], MyApp.prototype, "nav", void 0);
    MyApp = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\app\app.html"*/'<ion-menu [content]="content">\n\n    <ion-header>\n\n        <ion-toolbar>\n\n            <ion-title>Menu\n\n                <!-- <img src="assets/imgs/missouri.jpg" style="width: 100%; height: 100%" />  -->\n\n            </ion-title>\n\n        </ion-toolbar>\n\n    </ion-header>\n\n\n\n    <ion-content>\n\n        <ion-list>\n\n            <div style="text-align: center">\n\n                <img src="assets/imgs/logo_new.jpg" style="width: 80%; text-align: center" padding/>\n\n            </div>\n\n            <button menuClose ion-item *ngFor="let p of pages" menuClose (click)="openPage(p)">\n\n                {{p.title}}\n\n            </button>\n\n        </ion-list>\n\n    </ion-content>\n\n</ion-menu>\n\n<!-- Disable swipe-to-go-back because it\'s poor UX to combine STGB with side menus -->\n\n<ion-nav [root]="rootPage" #content swipeBackEnabled="false"></ion-nav>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\app\app.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_8__ionic_native_facebook__["a" /* Facebook */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["l" /* Platform */], __WEBPACK_IMPORTED_MODULE_2__ionic_native_status_bar__["a" /* StatusBar */], __WEBPACK_IMPORTED_MODULE_3__ionic_native_splash_screen__["a" /* SplashScreen */],
            __WEBPACK_IMPORTED_MODULE_4__ionic_storage__["b" /* Storage */]])
    ], MyApp);
    return MyApp;
}());

//# sourceMappingURL=app.component.js.map

/***/ }),

/***/ 55:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return OtpverificationPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__login_login__ = __webpack_require__(73);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__ionic_storage__ = __webpack_require__(19);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Generated class for the OtpverificationPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var OtpverificationPage = /** @class */ (function () {
    function OtpverificationPage(navCtrl, navParams, util, userAuth, storage, alertCtrl) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.util = util;
        this.userAuth = userAuth;
        this.storage = storage;
        this.alertCtrl = alertCtrl;
    }
    OtpverificationPage.prototype.ionViewDidLoad = function () {
        var _this = this;
        this.storage.get("dataEdit").then(function (value) {
            _this.editData = value;
            if (_this.editData == 1) {
                _this.userAuth.getUpdatemsg().then(function (result) {
                    console.log(result);
                    if (result['success']) {
                        _this.storage.set('dataEdit', 0);
                        _this.title = result['title'];
                        _this.subtitle = result['subtitle'];
                    }
                });
            }
            else {
                _this.userAuth.getRegistermsg().then(function (result) {
                    console.log(result);
                    if (result['success']) {
                        _this.title = result['title'];
                        _this.subtitle = result['subtitle'];
                    }
                });
            }
        });
    };
    OtpverificationPage.prototype.verifyOtp = function () {
        var _this = this;
        this.storage.get("user_id").then(function (value) {
            _this.userId = value;
            console.log(_this.otp);
            _this.util.presentLoading();
            _this.userAuth.verfyOtp(_this.userId, _this.otp).then(function (result) {
                console.log(result);
                _this.util.dismissLoading();
                if (result['success']) {
                    _this.showAlert();
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        });
    };
    OtpverificationPage.prototype.resendOtp = function () {
        var _this = this;
        this.storage.get("user_id").then(function (value) {
            _this.userId = value;
            console.log(_this.userId);
            _this.util.presentLoading();
            _this.userAuth.sendOtp(_this.userId).then(function (result) {
                console.log(result);
                _this.util.dismissLoading();
                if (result['success']) {
                    _this.util.presentToast(result['message']);
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        });
    };
    OtpverificationPage.prototype.showAlert = function () {
        var _this = this;
        var alert = this.alertCtrl.create({
            title: this.title,
            subTitle: this.subtitle,
            buttons: [{
                    text: 'Ok',
                    handler: function () {
                        // user has clicked the alert button
                        // begin the alert's dismiss transition
                        var navTransition = alert.dismiss();
                        _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_4__login_login__["a" /* LoginPage */]);
                        return false;
                    }
                }]
        });
        alert.present();
    };
    OtpverificationPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-otpverification',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\otpverification\otpverification.html"*/'<!--\n  Generated template for the OtpverificationPage page.\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n  Ionic pages and navigation.\n-->\n<ion-header>\n  <ion-navbar color="primary">\n      <button ion-button menuToggle left>\n    <!-- <ion-icon name="menu"></ion-icon> -->\n  </button>\n      <ion-title>OTP Verification</ion-title>\n  </ion-navbar>\n</ion-header>\n\n<ion-content padding>\n\n  <ion-list>\n    <ion-item>\n      <ion-input type="number" [(ngModel)]="otp" placeholder="Enter your OTP"></ion-input>\n    </ion-item>\n\n  </ion-list>\n\n  <div padding>\n    <p>OTP has been sent on you email id.</p>\n    <button (click)="verifyOtp()" ion-button block>Submit</button>\n    <p>Not received your OTP? <a (click)="resendOtp()">Resend OTP</a> </p>\n  </div>\n  \n\n</ion-content>\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\otpverification\otpverification.html"*/,
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */],
            __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_5__ionic_storage__["b" /* Storage */],
            __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["a" /* AlertController */]])
    ], OtpverificationPage);
    return OtpverificationPage;
}());

//# sourceMappingURL=otpverification.js.map

/***/ }),

/***/ 56:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ShowuseransPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ionic_angular__ = __webpack_require__(11);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};





/**
 * Generated class for the ShowuseransPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var ShowuseransPage = /** @class */ (function () {
    function ShowuseransPage(navCtrl, navParams, userAuth, menu, storage, util) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.menu = menu;
        this.storage = storage;
        this.util = util;
    }
    ShowuseransPage.prototype.ionViewDidLoad = function () {
        var _this = this;
        this.menu.enable(true);
        this.storage.get("user_id").then(function (value) {
            _this.user_id = value;
            _this.userAuth.getUserAns(_this.user_id).then(function (result) {
                //console.log('yes show me ans');
                // console.log(result);
                _this.ques = result[2]['ques'];
                _this.ans = result[2]['ans'];
                _this.yesans = result[0]['yes'];
                _this.noans = result[1]['noans'];
            });
        });
    };
    ShowuseransPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-showuserans',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\showuserans\showuserans.html"*/'<!--\n\n  Generated template for the ShowuseransPage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>Your answer</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n\n\n<ion-content padding>\n\n    <h5>Question: {{ques}}</h5>\n\n    <h5 *ngIf="ans==1">Answer: Yes</h5>\n\n    <h5 *ngIf="ans==0">Answer: No</h5>\n\n\n\n    <hr>\n\n    <h5> {{yesans}} People asnwered YES </h5>\n\n    <h5>{{noans}}  People asnwered NO </h5>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\showuserans\showuserans.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_2__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */]])
    ], ShowuseransPage);
    return ShowuseransPage;
}());

//# sourceMappingURL=showuserans.js.map

/***/ }),

/***/ 72:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UploadKYCDocPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__otpverification_otpverification__ = __webpack_require__(55);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6_ng2_file_upload__ = __webpack_require__(90);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Generated class for the UploadkycdocPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var UploadKYCDocPage = /** @class */ (function () {
    function UploadKYCDocPage(navCtrl, navParams, menu, util, userAuth, storage) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.menu = menu;
        this.util = util;
        this.userAuth = userAuth;
        this.storage = storage;
        this.MAX_FILES = 10;
        this.regiData = new FormData();
        this.fileUploader = new __WEBPACK_IMPORTED_MODULE_6_ng2_file_upload__["b" /* FileUploader */]({
            filters: [{
                    name: 'maxAllowedFilesFilter',
                    fn: this.maxFileSizeFilter.bind(this)
                }]
        });
    }
    UploadKYCDocPage.prototype.ionViewDidLoad = function () {
        this.fbdata = this.navParams.get('isfb');
    };
    // upload(event) {
    //   this.regiData.set('doc[]','');
    //   let files = event.target.files
    //   console.log(files);
    //   Array.from(files).forEach(function(file) {
    //     this.regiData.append('doc[]', file);
    //    }.bind(this));
    // }
    // uploadFiles() {
    //   let files = this.getFiles();
    //   let requests = [];
    //   this.regiData.set('doc[]','');
    //   files.forEach((file) => {
    //     this.regiData.append('doc[]' , file.rawFile, file.name);
    //     //console.log(this.regiData);
    //   });
    //   requests.push(this.userAuth.uploadKycimg(this.regiData,1));
    // }
    UploadKYCDocPage.prototype.uploadKYCImages = function () {
        var _this = this;
        this.storage.get("user_id").then(function (value) {
            _this.userId = value;
            _this.util.presentLoading();
            var files = _this.getFiles();
            var requests = [];
            _this.regiData.set('doc[]', '');
            files.forEach(function (file) {
                _this.regiData.append('doc[]', file.rawFile, file.name);
            });
            requests.push(_this.userAuth.uploadKycimg(_this.regiData, _this.userId).then(function (result) {
                _this.util.dismissLoading();
                if (result['success']) {
                    _this.userAuth.sendOtp(_this.userId).then(function (result) {
                        if (result['success']) {
                            _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__otpverification_otpverification__["a" /* OtpverificationPage */]);
                        }
                    });
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            }));
        });
    };
    UploadKYCDocPage.prototype.maxFileSizeFilter = function (item) {
        return this.fileUploader.queue.length < this.MAX_FILES;
    };
    UploadKYCDocPage.prototype.getFiles = function () {
        return this.fileUploader.queue.map(function (fileItem) {
            return fileItem.file;
        });
    };
    UploadKYCDocPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-uploadkycdoc',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\uploadkycdoc\uploadkycdoc.html"*/'<!--\n\n  Generated template for the UploadkycdocPage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>KYC and Other Documents</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n<ion-content padding>\n\n\n\n    <h4>Please upload scanned documents for KYC. This is required to enroll as Member of SPWA:</h4>\n\n\n\n    <ol>\n\n        <li>Scanned filled and signed application form</li>\n\n        <li>One Passport sized digital Photograph</li>\n\n        <li>Scanned Copy of Pan card</li>\n\n        <li>Scanned Copy of Aadhaar card</li>\n\n        <li>Copy of passport in case of NRI / Foreign National</li>\n\n        <li>1st & 3rd page of FBA where name of allottee/s is mentioned</li>\n\n        <li>Electronic Deposit Receipt of Rs.2000/-</li>\n\n    </ol>\n\n\n\n    <p><b>Account details-</b></p>\n\n\n\n    <ul>\n\n        <li>A/c No: 50200045877356</li>\n\n        <li>In favor of: SARE PETIOLES WELFARE ASSOCIATION </li>\n\n        <li>IFSC: HDFC0000280</li>\n\n        <li>Swift Code: HDFCINBB</li>\n\n    </ul>\n\n\n\n    <hr>\n\n    <ion-label>(You can select up to {{MAX_FILES}} files)</ion-label>\n\n    <input type="file" id="doc" name="doc[]" accept="image/*" ng2FileSelect [uploader]="fileUploader" multiple>\n\n\n\n    <h6>Your files: {{ fileUploader.queue.length }}</h6>\n\n\n\n    <ion-list>\n\n        <ion-item *ngFor="let item of fileUploader.queue">\n\n            <!--<ion-thumbnail item-start>\n\n                <img src="{{item.file}}">\n\n            </ion-thumbnail>-->\n\n            <h2>{{item.file.name}}</h2>\n\n\n\n            <button ion-button item-end clear (click)="fileUploader.removeFromQueue(item)">\n\n                <ion-icon name="close-circle"></ion-icon>\n\n            </button>\n\n        </ion-item>\n\n    </ion-list>\n\n\n\n    <button (click)="uploadKYCImages()" ion-button block [disabled]="!fileUploader.queue.length">Save</button>\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\uploadkycdoc\uploadkycdoc.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */],
            __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__["a" /* UserauthProvider */], __WEBPACK_IMPORTED_MODULE_4__ionic_storage__["b" /* Storage */]])
    ], UploadKYCDocPage);
    return UploadKYCDocPage;
}());

//# sourceMappingURL=uploadkycdoc.js.map

/***/ }),

/***/ 73:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LoginPage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__register_register__ = __webpack_require__(164);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__showquestions_showquestions__ = __webpack_require__(165);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__showuserans_showuserans__ = __webpack_require__(56);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__userdeavtive_userdeavtive__ = __webpack_require__(166);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__ionic_native_facebook__ = __webpack_require__(88);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__uploadkycdoc_uploadkycdoc__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__providers_userauth_social_login__ = __webpack_require__(299);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__viewprofile_viewprofile__ = __webpack_require__(98);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__otpverification_otpverification__ = __webpack_require__(55);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};













/**
 * Generated class for the LoginPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var LoginPage = /** @class */ (function () {
    function LoginPage(fb, navCtrl, navParams, userAuth, util, menu, socialLogin) {
        this.fb = fb;
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.util = util;
        this.menu = menu;
        this.socialLogin = socialLogin;
        this.isValid = false;
        this.isLoggedIn = false;
    }
    LoginPage.prototype.ionViewDidLoad = function () {
        console.log('ionViewDidLoad LoginPage');
        this.menu.enable(false);
    };
    LoginPage.prototype.onSelectChange = function (selectedValue) {
        this.isValid = !!this.email && !!this.password;
    };
    /**
     * Log in user with entered email & password.
     */
    LoginPage.prototype.loginWithEmailAndPassword = function () {
        var _this = this;
        var loginData = new FormData;
        loginData.append('email', this.email);
        loginData.append('password', this.password);
        this.util.presentLoading();
        this.userAuth.loginUser(loginData).then(function (result) {
            _this.util.dismissLoading();
            if (result['success']) {
                // Display success Toast
                _this.util.presentToast(result['message']);
                //Add values in storage
                _this.userAuth.handleLoginSuccess(result.user_id);
                // this.storage.store(this.storage.KEY_LOGIN_ID, result['id']);
                // this.storage.store(this.storage.KEY_LOGIN_TYPE, result['type']);
                if (result['otpStatus'] == '0') {
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_12__otpverification_otpverification__["a" /* OtpverificationPage */]);
                    return false;
                }
                _this.menu.enable(true);
                _this.userAuth.getUserAns(result['user_id']).then(function (result) {
                    if (result[2] != "") {
                        //this.navCtrl.push(ShowuseransPage);
                        _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_6__showuserans_showuserans__["a" /* ShowuseransPage */]);
                    }
                    else {
                        _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__showquestions_showquestions__["a" /* ShowquestionsPage */]);
                    }
                });
                //Redirect to dashboard
            }
            else if (result['lgn'] == 0) {
                _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_7__userdeavtive_userdeavtive__["a" /* UserdeavtivePage */]);
            }
            else {
                _this.util.presentToast(result['message']);
            }
        });
        this.util.dismissLoading();
    };
    // public showFingerprintModal() {
    //   this.fingerprintOptions = {
    //       clientId: 'fingerprint-Demo',
    //       clientSecret: 'password', //Only necessary for Android
    //       disableBackup:true  //Only for Android(optional)
    //   }
    //   this.faio.isAvailable().then(result =>{
    //   if(result === "finger")
    //   {
    //       this.faio.show(this.fingerprintOptions)
    //       .then((result: any) => this.navCtrl.setRoot(HomePage)
    //       )
    //       .catch((error: any) => console.log(error));
    //   }
    //   });
    // }
    LoginPage.prototype.goToRegisterPage = function () {
        this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_4__register_register__["a" /* RegistrationPage */]);
    };
    LoginPage.prototype.loginWithFacebook = function () {
        var _this = this;
        // Login with permissions
        this.fb.login(['public_profile', 'email'])
            .then(function (res) {
            // The connection was successful
            if (res.status == "connected") {
                _this.isLoggedIn = true;
                _this.getUserDetail(res.authResponse.userID);
                // Get user ID and Token
                //var fb_id = res.authResponse.userID;
                //var fb_token = res.authResponse.accessToken;
            }
            else {
                // An error occurred while logging-in
                console.log("An error occurred...");
            }
        })
            .catch(function (e) {
            console.log('Error logging into Facebook', e);
        });
    };
    /**
     * Initiate login with Apple.
     */
    LoginPage.prototype.loginWithApple = function () {
        return __awaiter(this, void 0, void 0, function () {
            var appleData, e_1, data, promise, apiData, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, 2, , 3]);
                        return [4 /*yield*/, this.socialLogin.cordovaAppleSignIn()];
                    case 1:
                        appleData = _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        e_1 = _a.sent();
                        if (e_1.code === '1001' || e_1.code === '1003') {
                            this.util.presentToast('You cancelled the sign-in');
                        }
                        else {
                            this.util.presentToast('Unable to process your sign-in with subscription');
                        }
                        return [2 /*return*/];
                    case 3:
                        data = {
                            email: appleData.email,
                            name: appleData.name,
                            authorizationCode: appleData.authorizationCode
                        };
                        promise = this.userAuth.loginWithApple(data);
                        this.util.showLoadingFor(promise);
                        _a.label = 4;
                    case 4:
                        _a.trys.push([4, 6, , 7]);
                        return [4 /*yield*/, promise];
                    case 5:
                        apiData = _a.sent();
                        return [3 /*break*/, 7];
                    case 6:
                        e_2 = _a.sent();
                        this.util.presentToast('Unable to log you in.');
                        return [2 /*return*/];
                    case 7:
                        if (apiData.success && apiData.ltype == '0' || apiData.ltype == '1') {
                            //Display success Toast
                            this.menu.enable(true);
                            this.util.presentToast(apiData['message']);
                            this.userAuth.handleLoginSuccess(apiData.userId);
                            this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_11__viewprofile_viewprofile__["a" /* ViewprofilePage */], { isfb: "1" });
                            if (apiData.success && apiData.ltype == '0' || apiData.ltype == '1') {
                                //Display sucess Toast
                                this.menu.enable(true);
                                this.util.presentToast(apiData['message']);
                                this.userAuth.handleLoginSuccess(apiData.userId);
                                this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_9__uploadkycdoc_uploadkycdoc__["a" /* UploadKYCDocPage */], { isapple: "1" });
                            }
                            else if (apiData.success && apiData.ans == '0') {
                                this.userAuth.handleLoginSuccess(apiData.userId);
                                this.util.presentToast(apiData['message']);
                                this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__showquestions_showquestions__["a" /* ShowquestionsPage */]);
                            }
                            else if (apiData.success && apiData.ans == '1') {
                                this.menu.enable(true);
                                this.userAuth.handleLoginSuccess(apiData.userId);
                                this.util.presentToast(apiData['message']);
                                this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_6__showuserans_showuserans__["a" /* ShowuseransPage */]);
                            }
                            else if (apiData['lgn'] == 0) {
                                this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_7__userdeavtive_userdeavtive__["a" /* UserdeavtivePage */]);
                            }
                            else {
                                this.util.presentToast(apiData['message']);
                            }
                        }
                        else {
                            this.util.presentToast(apiData['message']);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    LoginPage.prototype.getUserDetail = function (userid) {
        var _this = this;
        this.fb.api("/" + userid + "/?fields=id,email,name,picture", ["public_profile"])
            .then(function (res) {
            console.log(res);
            _this.users = res;
            _this.uname = res.name;
            _this.uemail = res.email;
            _this.userAuth.fblogin(_this.uname, _this.uemail).then(function (result) {
                //console.log(result);
                _this.util.dismissLoading();
                if (result['success'] && result['ltype'] == '0' || result['ltype'] == '1') {
                    //Display sucess Toast
                    _this.menu.enable(true);
                    _this.util.presentToast(result['message']);
                    _this.userAuth.handleLoginSuccess(result.userId);
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_9__uploadkycdoc_uploadkycdoc__["a" /* UploadKYCDocPage */], { isfb: "1" });
                }
                else if (result['success'] && result['ans'] == '0') {
                    _this.userAuth.handleLoginSuccess(result.userId);
                    _this.util.presentToast(result['message']);
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__showquestions_showquestions__["a" /* ShowquestionsPage */]);
                }
                else if (result['success'] && result['ans'] == '1') {
                    _this.menu.enable(true);
                    _this.userAuth.handleLoginSuccess(result.userId);
                    _this.util.presentToast(result['message']);
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_6__showuserans_showuserans__["a" /* ShowuseransPage */]);
                }
                else if (result['lgn'] == 0) {
                    _this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_7__userdeavtive_userdeavtive__["a" /* UserdeavtivePage */]);
                }
                else {
                    _this.util.presentToast(result['message']);
                }
            });
        })
            .catch(function (e) {
            console.log(e);
        });
    };
    LoginPage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-login',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\login\login.html"*/'<ion-content  class="animated fadeIn login auth-page no-scroll">\n\n    <div class="login-content">\n\n        <div  text-center class="animated fadeInDown" style="height: 250px; overflow: hidden;" >\n\n            <img width="100%" height="auto" class="logo" src="assets/imgs/logo_new_2.png">\n\n            <br>\n\n            \n\n        </div>\n\n\n\n            <div style="text-align: center;"><span style="font-size: 20px; ">Login to <br><strong>SARE GGN Buyers</strong></span></div>\n\n        <div class="list-form" padding>\n\n            <!-- <button ion-button icon-center medium full color="light" style="height:87px;    box-shadow: none;\n\n            top: 3px;\n\n            background-color: white;" (click)="showFingerprintModal()">\n\n              <ion-icon name="finger-print" style="font-size: 83px;border-radius: 50%;\n\n              background-color: #488aff;\n\n              height: 85px;\n\n              width: 86px;"></ion-icon>\n\n            </button> -->\n\n            <ion-item>\n\n                <ion-label floating>\n\n                    <ion-icon name="mail" item-start class="text-primary"></ion-icon>\n\n                    Email\n\n                </ion-label>\n\n                <ion-input type="email" [(ngModel)]="email" (ionChange)="onSelectChange($event)"></ion-input>\n\n            </ion-item>\n\n\n\n            <ion-item>\n\n                <ion-label floating>\n\n                    <ion-icon name="lock" item-start class="text-primary"></ion-icon>\n\n                    Password\n\n                </ion-label>\n\n                <ion-input type="password" (ionChange)="onSelectChange($event)" [(ngModel)]="password"></ion-input>\n\n            </ion-item>\n\n            <br>\n\n        </div> \n\n\n\n        <div padding>\n\n            <button (click)="loginWithEmailAndPassword()" [disabled]="!isValid" ion-button block class="mb-1">Login</button>\n\n\n\n            <button (click)="loginWithFacebook()" ion-button block class="mb-1">\n\n                <ion-icon name="logo-facebook"></ion-icon>\n\n                Login With Facebook\n\n            </button>\n\n\n\n            <button (click)="loginWithApple()" ion-button block showWhen="ios" color="dark" class="mb-1">\n\n                <ion-icon name="logo-apple"></ion-icon>\n\n                Sign in with Apple\n\n            </button>\n\n            <!--<button ion-button block (click)="showFingerprintModal()">Login With Fingerprint </button> -->\n\n\n\n            <button expand="block" ion-button block color="secondary" (click)="goToRegisterPage()">Register</button>\n\n        </div>\n\n    </div>\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\login\login.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_8__ionic_native_facebook__["a" /* Facebook */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_2__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */], __WEBPACK_IMPORTED_MODULE_1_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_10__providers_userauth_social_login__["a" /* SocialLogin */]])
    ], LoginPage);
    return LoginPage;
}());

//# sourceMappingURL=login.js.map

/***/ }),

/***/ 98:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ViewprofilePage; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__angular_core__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ionic_storage__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__providers_util_util__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_ionic_angular__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__editprofile_editprofile__ = __webpack_require__(167);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__editdocs_editdocs__ = __webpack_require__(168);
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};







/**
 * Generated class for the ViewprofilePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
var ViewprofilePage = /** @class */ (function () {
    function ViewprofilePage(navCtrl, navParams, userAuth, menu, storage, util) {
        this.navCtrl = navCtrl;
        this.navParams = navParams;
        this.userAuth = userAuth;
        this.menu = menu;
        this.storage = storage;
        this.util = util;
    }
    ViewprofilePage.prototype.ionViewDidLoad = function () {
        var _this = this;
        this.storage.get("user_id").then(function (value) {
            _this.user_id = value;
            console.log(_this.user_id + 'view profile');
            _this.util.presentLoading();
            _this.userAuth.viewProfile(_this.user_id).then(function (result) {
                _this.util.dismissLoading();
                // console.log(result);
                _this.uid = result['data'][0]['uid'];
                _this.uname = result['data'][0]['uname'];
                _this.dob = result['data'][0]['dob'];
                _this.docs = result['data'][1]['kyc_img'];
                _this.imgIds = result['data'][1]['imgid'];
                _this.doctype = result['data'][0]['doctype'];
                _this.phone = result['data'][0]['phone'];
                _this.country = result['data'][0]['country'];
                _this.editprofile = result['data'][0]['editProfile'];
                _this.ucity = result['data'][0]['ucity'];
                _this.uimage = result['data'][0]['uimage'];
                _this.ustate = result['data'][0]['ustate'];
                // console.log('yes loaded');
                //console.log(result['data']);
                var ar1 = _this.docs;
                var ar2 = _this.imgIds;
                var ar3 = [];
                for (var i = 0; i < ar1.length; i++) {
                    ar3.push({ "id": ar2[i], "url": ar1[i] });
                }
                _this.result2 = Array.from(ar3);
            });
        });
    };
    ViewprofilePage.prototype.editProfile = function () {
        this.navCtrl.setRoot(__WEBPACK_IMPORTED_MODULE_5__editprofile_editprofile__["a" /* EditprofilePage */]);
    };
    ViewprofilePage.prototype.editDocs = function (imgid) {
        console.log(imgid);
        this.navCtrl.push(__WEBPACK_IMPORTED_MODULE_6__editdocs_editdocs__["a" /* EditdocsPage */], { imgId: imgid });
    };
    ViewprofilePage = __decorate([
        Object(__WEBPACK_IMPORTED_MODULE_0__angular_core__["m" /* Component */])({
            selector: 'page-viewprofile',template:/*ion-inline-start:"E:\IonicAppSpcae\sareggn\src\pages\viewprofile\viewprofile.html"*/'<!--\n\n  Generated template for the ViewprofilePage page.\n\n\n\n  See http://ionicframework.com/docs/components/#navigation for more info on\n\n  Ionic pages and navigation.\n\n-->\n\n<ion-header>\n\n    <ion-navbar color="primary">\n\n        <button ion-button menuToggle left>\n\n            <ion-icon name="menu"></ion-icon>\n\n        </button>\n\n        <ion-title>View Profile</ion-title>\n\n    </ion-navbar>\n\n</ion-header>\n\n\n\n\n\n<ion-content padding>\n\n    <h5 class="text-center">Profile Details</h5>\n\n    <p>Personal Details | &nbsp;&nbsp; <a *ngIf="editprofile==1" (click)=editProfile()>Edit Profile</a></p>\n\n    <p>Name: {{uname}}</p>\n\n    <p>User Id: {{uid}}</p>\n\n    <p>Phone: {{phone}}</p>\n\n    <p>Country: {{country}}</p>\n\n    <h5>Kyc Details</h5>\n\n    <p>Documents:</p>\n\n\n\n    <div *ngFor="let r of result2">\n\n        <img class=\'img-fluid\' src="https://git.instaacoders.com/api/uploads/{{r.url}}"/>\n\n        <p><a *ngIf="editprofile==1" (click)="editDocs(r.id)">Edit</a></p>\n\n    </div>\n\n\n\n\n\n</ion-content>\n\n'/*ion-inline-end:"E:\IonicAppSpcae\sareggn\src\pages\viewprofile\viewprofile.html"*/
        }),
        __metadata("design:paramtypes", [__WEBPACK_IMPORTED_MODULE_4_ionic_angular__["j" /* NavController */], __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["k" /* NavParams */], __WEBPACK_IMPORTED_MODULE_1__providers_userauth_userauth__["a" /* UserauthProvider */],
            __WEBPACK_IMPORTED_MODULE_4_ionic_angular__["h" /* MenuController */], __WEBPACK_IMPORTED_MODULE_2__ionic_storage__["b" /* Storage */], __WEBPACK_IMPORTED_MODULE_3__providers_util_util__["a" /* UtilProvider */]])
    ], ViewprofilePage);
    return ViewprofilePage;
}());

//# sourceMappingURL=viewprofile.js.map

/***/ })

},[301]);
//# sourceMappingURL=main.js.map