import {Component, ViewChild} from '@angular/core';
import {Nav, Platform} from 'ionic-angular';
import {StatusBar} from '@ionic-native/status-bar';
import {SplashScreen} from '@ionic-native/splash-screen';
import {Storage} from '@ionic/storage';
import {LoginPage} from '../pages/login/login';
import {ViewprofilePage} from '../pages/viewprofile/viewprofile';
import {ShowuseransPage} from '../pages/showuserans/showuserans';
import {Facebook} from '@ionic-native/facebook';


@Component({
    templateUrl: 'app.html'
})
export class MyApp {
    @ViewChild(Nav) nav: Nav;
    rootPage: any = 'LoginPage';

    pages: Array<{ title: string, component: any }>;

    constructor(private fb: Facebook, public platform: Platform, public statusBar: StatusBar, public splashScreen: SplashScreen,
                private storage: Storage) {
        this.initializeApp();

        // used for an example of ngFor and navigation
        this.pages = [
            {title: 'View Profile', component: ViewprofilePage},
            {title: 'Sign out', component: 'signout'}
        ];
    }

    initializeApp() {
        this.platform.ready().then(() => {
            // Okay, so the platform is ready and our plugins are available.
            // Here you can do any higher level native things you might need.
            //this.statusBar.styleDefault();

            this.storage.get('isLogin').then(value => {
                console.log('Login status', value);
                //if(value) this.rootPage = LoginFingerPage
                if (value) this.rootPage = ShowuseransPage;

            });
            this.statusBar.backgroundColorByHexString('secondary');
            this.splashScreen.hide();

        });
    }

    openPage(page) {
        // Reset the content nav to have just this page
        // we wouldn't want the back button to show in this scenario
        if (page.component == 'signout') {
            this.fb.logout();
            this.storage.set('isLogin', false);
            this.storage.remove('user_id');
            //this.rootPage = LoginPage
            this.nav.setRoot(LoginPage);
        } else {
            this.nav.setRoot(page.component);
        }
    }
}
