import {NextPage} from './../pages/next/next';
import {BrowserModule} from '@angular/platform-browser';
import {ErrorHandler, NgModule} from '@angular/core';
import {Facebook} from '@ionic-native/facebook';
import {IonicApp, IonicErrorHandler, IonicModule} from 'ionic-angular';
import {RegistrationPage} from '../pages/register/register';
import {MyApp} from './app.component';
import {HomePage} from '../pages/home/home';
import {ListPage} from '../pages/list/list';
import {UploadKYCDocPage} from '../pages/uploadkycdoc/uploadkycdoc';

import {StatusBar} from '@ionic-native/status-bar';
import {SplashScreen} from '@ionic-native/splash-screen';
import {Camera} from '@ionic-native/camera';
import {UserauthProvider} from '../providers/userauth/userauth';
import {HttpClientModule} from '@angular/common/http';
import {UtilProvider} from '../providers/util/util';

import {IonicStorageModule} from '@ionic/storage';
import {SQLite} from '@ionic-native/sqlite';
import {FileTransfer} from '@ionic-native/file-transfer';
import {FilePath} from '@ionic-native/file-path';
import {Network} from '@ionic-native/network';
import {FingerprintAIO} from '@ionic-native/fingerprint-aio';
import {File} from '@ionic-native/file/ngx';
import {LoginFingerPage} from '../pages/login-finger/login-finger';
import {ShowquestionsPage} from '../pages/showquestions/showquestions';
import {MfilePage} from '../pages/mfile/mfile';
import {ShowuseransPage} from '../pages/showuserans/showuserans';
import {UserdeavtivePage} from '../pages/userdeavtive/userdeavtive';
import {ViewprofilePage} from '../pages/viewprofile/viewprofile';
import {KycProvider} from '../providers/kyc/kyc';
import {EditprofilePage} from '../pages/editprofile/editprofile';
import {EditdocsPage} from '../pages/editdocs/editdocs';
import {FbloginPage} from '../pages/fblogin/fblogin';
import {OtpverificationPage} from '../pages/otpverification/otpverification';
import {MfilePageModule} from '../pages/mfile/mfile.module';
import {UploadkycdocPageModule} from '../pages/uploadkycdoc/uploadkycdoc.module';

@NgModule({
    declarations: [
        MyApp,
        HomePage,
        ListPage,
        NextPage,
        RegistrationPage,
        LoginFingerPage,
        ShowquestionsPage,
        ShowuseransPage,
        ViewprofilePage,
        EditprofilePage,
        EditdocsPage,
        FbloginPage,
        UserdeavtivePage,
        OtpverificationPage
    ],
    imports: [
        BrowserModule,
        HttpClientModule,
        MfilePageModule,
        UploadkycdocPageModule,
        IonicModule.forRoot(MyApp),
        IonicStorageModule.forRoot()
    ],
    bootstrap: [IonicApp],
    entryComponents: [
        MyApp,
        HomePage,
        ListPage,
        NextPage,
        RegistrationPage,
        LoginFingerPage,
        ShowquestionsPage,
        ShowuseransPage,
        ViewprofilePage,
        UploadKYCDocPage,
        EditprofilePage,
        EditdocsPage,
        FbloginPage,
        UserdeavtivePage,
        MfilePage,
        OtpverificationPage
    ],
    providers: [
        StatusBar,
        SplashScreen,
        Camera,
        SQLite,
        FileTransfer,
        FilePath,
        Network,
        {provide: ErrorHandler, useClass: IonicErrorHandler},
        Facebook,
        UserauthProvider,
        UtilProvider,
        FingerprintAIO,
        File,
        KycProvider
    ]
})
export class AppModule {
}
