import {Component} from '@angular/core';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from "@ionic/storage";
import {UtilProvider} from '../../providers/util/util';
import {OtpverificationPage} from '../otpverification/otpverification';

/**
 * Generated class for the EditdocsPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-editdocs',
    templateUrl: 'editdocs.html'
})
export class EditdocsPage {
    userId: any;
    imageId: any;
    userdata: any;
    doc: any;
    regiData = new FormData;

    constructor(public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public menu: MenuController, private storage: Storage, public util: UtilProvider) {
        console.log(this.navParams.data.imgId + 'params');
        this.imageId = this.navParams.data.imgId;
    }

    ionViewDidLoad() {
        //console.log(this.imageId+'this is ');
    }


    upload(file: File) {
        //console.log(file[0])
        this.doc = file[0];
        this.regiData.append('doc', this.doc);
    }


    updateDoc() {
        // console.log(this.imageId+'this is ');
        this.storage.get("user_id").then(value => {
            this.userId = value;
            this.util.presentLoading();
            //console.log(this.regiData);
            // console.log('yes here in edit docs');
            //console.log(this.imageId);
            this.userAuth.updateDoc(this.regiData, this.userId, this.imageId).then((result) => {
                // console.log(result);
                this.util.dismissLoading();
                if (result['success']) {
                    //this.storage.set('dataEdit', 1);
                    //this.sendOtp();
                    //Display sucess Toast
                    this.util.presentToast(result['message']);
                    //this.navCtrl.setRoot(LoginPage);
                    //this.storage.set('userId', result['userId']);
                    //this.navCtrl.setRoot(UploadkycdocPage);


                } else {
                    this.util.presentToast(result['message']);
                }
            });

        });

    }


    sendOtp(){
        this.storage.get("user_id").then(value => {
          this.userId = value;
          console.log(this.userId);
          this.util.presentLoading(); 
           this.userAuth.sendOtp(this.userId).then((result) => {
          console.log(result);
          this.util.dismissLoading();
          if (result['success']) {
            this.navCtrl.setRoot(OtpverificationPage);
          } else {
            this.util.presentToast(result['message']);
          }
        });
    
        });
    
      }



}
