import {Component} from '@angular/core';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from "@ionic/storage";
import {UtilProvider} from '../../providers/util/util';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import { AlertController } from 'ionic-angular';
import {LoginPage} from '../login/login';
import {OtpverificationPage} from '../otpverification/otpverification';

/**
 * Generated class for the EditprofilePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-editprofile',
    templateUrl: 'editprofile.html'
})
export class EditprofilePage {
    isValid: boolean = false;
    user_id: any;
    userId: any;
    name: string;
    email: string;
    phoneno: any;
    city: string;
    country: string;
    state: string;
    countryData: any[];
    dob: any;
    regiData = new FormData;

    constructor(public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public menu: MenuController, private storage: Storage, public util: UtilProvider,public alertCtrl: AlertController) {
    }

    ionViewDidLoad() {

        this.userAuth.getCountry().then((result) => {
            //console.log(result);
            this.countryData = Array.from(result['data']);
            console.log(this.countryData.length);
            this.util.dismissLoading();
            if (result['success']) {

            }
        });


        this.storage.get("user_id").then(value => {
            this.user_id = value;
            //console.log('this is profile edit page');
            //console.log(this.user_id);
            this.userAuth.editProfile(this.user_id).then((result) => {
                console.log(result['data']);
                this.userId = result['data'].user_no;
                this.name = result['data'].user_name;
                this.email = result['data'].user_id;
                this.phoneno = result['data'].phone_no;
                this.city = result['data'].uCity;
                this.state = result['data'].uState;
                this.dob = result['data'].dob;
                this.country = result['data'].country;
            });

        });
    }

    onSelectChange(selectedValue: any) {
        if (this.email != '' && this.name != '' && this.city != '' && this.state != '' && this.phoneno != '')
            this.isValid = true;
        else
            this.isValid = false;
    }

    updateProfile() {
        this.regiData.append('name', this.name);
        this.regiData.append('email', this.email);
        this.regiData.append('phone', this.phoneno);
        this.regiData.append('city', this.city);
        this.regiData.append('state', this.state);
        this.regiData.append('dob', this.dob);
        this.regiData.append('user_id', this.userId);
        this.regiData.append('country', this.country);

        this.util.presentLoading();
        this.userAuth.updateProfile(this.regiData).then((result) => {
            console.log(result);
            this.util.dismissLoading();
            if (result['success']) {
               this.storage.set('dataEdit', 1);
               this.sendOtp();

                // console.log('yes updated');
                //Display sucess Toast
                //this.util.presentToast(result['message']);
                //this.navCtrl.setRoot(LoginPage);
                //this.storage.set('userId', result['userId']);
                //this.navCtrl.setRoot(UploadkycdocPage);


            } else {
                this.util.presentToast(result['message']);
            }
        });

    }

    sendOtp(){
        this.storage.get("user_id").then(value => {
          this.userId = value;
          console.log(this.userId);
          this.util.presentLoading(); 
           this.userAuth.sendOtp(this.userId).then((result) => {
          console.log(result);
          this.util.dismissLoading();
          if (result['success']) {
            this.navCtrl.setRoot(OtpverificationPage);
          } else {
            this.util.presentToast(result['message']);
          }
        });
    
        });
    
      }

     
}
