import {Component} from '@angular/core';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from "@ionic/storage";
import {UtilProvider} from '../../providers/util/util';
import {UploadKYCDocPage} from '../uploadkycdoc/uploadkycdoc';
import {ShowuseransPage} from '../showuserans/showuserans';
import {Facebook, FacebookLoginResponse} from '@ionic-native/facebook';

/**
 * Generated class for the FbloginPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-fblogin',
    templateUrl: 'fblogin.html'
})
export class FbloginPage {
    constructor(private fb: Facebook, public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public menu: MenuController, private storage: Storage, public util: UtilProvider) {
    }

    isLoggedIn: boolean = false;
    users: any;
    uname: any;
    uemail: any;

    loginAction() {
        // Login with permissions
        this.fb.login(['public_profile', 'email'])
            .then((res: FacebookLoginResponse) => {

                // The connection was successful
                if (res.status == "connected") {

                    this.isLoggedIn = true;
                    this.getUserDetail(res.authResponse.userID);
                    // Get user ID and Token
                    //var fb_id = res.authResponse.userID;
                    //var fb_token = res.authResponse.accessToken;
                }
                // An error occurred while loging-in
                else {

                    console.log("An error occurred...");

                }

            })
            .catch((e) => {
                console.log('Error logging into Facebook', e);
            });
    }

    getUserDetail(userid) {
        this.fb.api("/" + userid + "/?fields=id,email,name,picture", ["public_profile"])
            .then(res => {
                console.log(res);
                this.users = res;
                this.uname = res.name;
                this.uemail = res.email;
                this.userAuth.fblogin(this.uname, this.uemail).then((result) => {
                    // console.log(result);
                    this.util.dismissLoading();
                    if (result['success'] && result['ltype'] == '0' || result['ltype'] == '1') {
                        //Display sucess Toast
                        this.util.presentToast(result['message']);
                        this.storage.set('isLogin', true);
                        this.storage.set('user_id', result['userId']);
                        this.navCtrl.setRoot(UploadKYCDocPage);
                    } else if (result['success'] && result['ltype'] == '2') {
                        this.storage.set('user_id', result['userId']);
                        this.util.presentToast(result['message']);
                        this.storage.set('isLogin', true);
                        this.menu.enable(true);
                        this.navCtrl.setRoot(ShowuseransPage);
                    } else {
                        this.util.presentToast(result['message']);
                    }
                });


            })
            .catch(e => {
                console.log(e);
            });
    }

    logout() {
        this.fb.logout()
            .then(res => this.isLoggedIn = false)
            .catch(e => console.log('Error logout from Facebook', e));
    }

}
