import {Component} from "@angular/core";
import {MenuController, NavController} from "ionic-angular";
import {Camera, CameraOptions} from "@ionic-native/camera";
import {SQLite, SQLiteObject} from "@ionic-native/sqlite";
import {Storage} from "@ionic/storage";
import {UtilProvider} from "../../providers/util/util";
import {UserauthProvider} from "../../providers/userauth/userauth";
import {FileTransfer, FileTransferObject, FileUploadOptions} from "@ionic-native/file-transfer";
import {Network} from "@ionic-native/network";
import {ListPage} from "../list/list";

@Component({
    selector: "page-home",
    templateUrl: "home.html"
})
export class HomePage {
    user_id: number;
    screenDate: string = "";
    school_name: string = "";
    screener_name: string = "";
    gender: string = "";
    race: string = "";
    Hygiene: string = "";
    treated: any = [];
    sealants: string = "";
    history: string = "";
    white_spot: string = "";
    untreated: string = "";
    treatment: string = "";
    childhood: string = "";
    age: string = "";
    imageData: any;

    constructor(
        public navCtrl: NavController,
        private camera: Camera,
        public menu: MenuController,
        private transfer: FileTransfer,
        public sqlite: SQLite,
        private storage: Storage,
        public util: UtilProvider,
        public userAuth: UserauthProvider,
        private network: Network
    ) {
        this.menu.enable(true);
        this.createDB();

        this.storage.get("user_id").then(value => {
            console.log("Login user id", value);
            this.user_id = value;
        });

    }

    takePicture() {
        const options: CameraOptions = {
            quality: 100,
            destinationType: this.camera.DestinationType.FILE_URI,
            encodingType: this.camera.EncodingType.JPEG,
            mediaType: this.camera.MediaType.PICTURE
        };

        this.camera.getPicture(options).then(
            imageData => {
                console.log("imageData : ", imageData);
                this.imageData = imageData;
            },
            err => {
                // Handle error
                console.log("Camera image error", err);
            }
        );
    }

    saveData() {
        console.log("treated", this.treated);
        let treat_urgency = "";
        for (let i = 0; i < this.treated.length; i++) {
            treat_urgency += this.treated[i];
            if (i < this.treated.length - 1) treat_urgency += ",";
        }
        this.treated = treat_urgency;
        console.log("treat_urgency", treat_urgency);

        console.log("network connection type: ", this.network.type);
        console.log("image Data", this.imageData);
        // console.log('screener_name=', this.screener_name);
        if (this.screenDate === "" || this.screenDate === "undefined") {
            this.util.presentCustomToast("Please select Screen Date");
        } else if (this.school_name === "" || this.school_name === "undefined") {
            this.util.presentCustomToast("Please Enter School Name");
        } else if (
            this.screener_name === "" ||
            this.screener_name === "undefined"
        ) {
            this.util.presentCustomToast("Please Enter Screener Name");
        } else if (this.gender === "" || this.gender === "undefined") {
            this.util.presentCustomToast("Please select your gender");
        } else if (this.gender === "" || this.gender === "undefined") {
            this.util.presentCustomToast("Please select your gender");
        } else if (this.race === "" || this.race === "undefined") {
            this.util.presentCustomToast("Please select your Race/Ethnicity.");
        } else if (this.Hygiene === "" || this.Hygiene === "undefined") {
            this.util.presentCustomToast("Please select your Oral Hygiene.");
        } else if (this.treated === "" || this.treated === "undefined") {
            this.util.presentCustomToast("Please select your Treated Decay.");
        } else if (this.sealants === "" || this.sealants === "undefined") {
            this.util.presentCustomToast(
                "Please select your Presence of Dental Sealants."
            );
        } else if (this.history === "" || this.history === "undefined") {
            this.util.presentCustomToast(
                "Please select your History of Rampant Caries?."
            );
        } else if (this.white_spot === "" || this.white_spot === "undefined") {
            this.util.presentCustomToast("Please select your White Spot Lesions?.");
        } else if (this.age === "" || this.age === "undefined") {
            this.util.presentCustomToast("Please select proper age.");
        } else if (this.untreated === "" || this.untreated === "undefined") {
            this.util.presentCustomToast("Please select Untreated Decay.");
        } else if (this.treatment === "" || this.treatment === "undefined") {
            this.util.presentCustomToast("Please select Treatment Urgency.");
        } else if (this.childhood === "" || this.childhood === "undefined") {
            this.util.presentCustomToast("Please select Early Childhood Caries?.");
        } else {
            if (!this.imageData) {
                this.imageData = "";
            }
            if (this.network.type == "none") this.save_data_offile();
            else this.uploadData();
        }
    }

    save_data_offile() {
        console.log(
            this.screenDate +
            "-" +
            this.gender +
            "-" +
            this.race +
            "-" +
            this.Hygiene +
            "-" +
            this.treated +
            "-" +
            this.sealants +
            "-" +
            this.history +
            "-" +
            this.white_spot +
            "-" +
            this.untreated +
            "-" +
            this.treatment +
            "-" +
            this.childhood
        );

        this.sqlite
            .create({
                name: "datadb.db",
                location: "default"
            })
            .then((db: SQLiteObject) => {
                //Insert record
                db.executeSql(
                    "INSERT INTO screendata VALUES(NULL,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)",
                    [
                        this.screenDate,
                        this.school_name,
                        this.screener_name,
                        this.gender,
                        this.race,
                        this.Hygiene,
                        this.treated,
                        this.sealants,
                        this.history,
                        this.white_spot,
                        this.age,
                        this.untreated,
                        this.treatment,
                        this.childhood,
                        this.imageData,
                        this.user_id
                    ]
                )
                    .then(res => {
                        console.log("insert result", res);
                        this.util.presentCustomToast("Data is saved...");
                        this.navCtrl.setRoot(ListPage);
                    })
                    .catch(e => console.log("insert query error: ", e));
            })
            .catch(e => console.log("Open DB Create DB", e));
    }

    uploadData() {
        let imagepath = this.imageData;
        if (imagepath != '') {
            this.util.presentLoading();
            const fileTransfer: FileTransferObject = this.transfer.create();

            let options: FileUploadOptions = {
                fileKey: "image",
                chunkedMode: false,
                mimeType: "multipart/form-data",
                headers: {},
                params: {
                    user_id: this.user_id,
                    gender: this.gender,
                    race: this.race,
                    oral_hygiene: this.Hygiene,
                    treated_decay: this.treated,
                    presence: this.sealants,
                    history_rampant_caries: this.history,
                    spot_lesions: this.white_spot,
                    age: this.age,
                    untreated_decay: this.untreated,
                    treatment_urgency: this.treatment,
                    early_childhood_caries: this.childhood,
                    screening_date: this.screenDate,
                    school_name: this.school_name,
                    screener_name: this.screener_name
                }
            };
            fileTransfer
                .upload(
                    imagepath,
                    "http://git.instaacoders.com/api/add_data.php",
                    options
                )
                .then(
                    data => {
                        let response: any = JSON.parse(data.response);
                        // save response in storage
                        this.util.dismissLoading();
                        this.util.presentToast(response.message);
                        console.log("response", response);
                    },
                    err => {
                        console.log(err);
                    }
                );
        } else {
            this.uploadOnlyData();
        }
    }

    createDB() {
        this.sqlite
            .create({
                name: "datadb.db",
                location: "default"
            })
            .then((db: SQLiteObject) => {
                console.log(
                    "CREATE TABLE IF NOT EXISTS screendata(id INTEGER PRIMARY KEY," +
                    "screening_date TEXT,school_name TEXT,screener_name TEXT, gender TEXT, race TEXT, oral_hygiene TEXT, treated_decay TEXT, presence TEXT," +
                    "history_rampant_caries TEXT, spot_lesions TEXT, age TEXT, untreated_decay TEXT, treatment_urgency TEXT, early_childhood_caries TEXT, image TEXT," +
                    "user_id TEXT)"
                );

                db.executeSql(
                    "CREATE TABLE IF NOT EXISTS screendata(id INTEGER PRIMARY KEY," +
                    "screening_date TEXT,school_name TEXT,screener_name TEXT, gender TEXT, race TEXT, oral_hygiene TEXT, treated_decay TEXT, presence TEXT," +
                    "history_rampant_caries TEXT, spot_lesions TEXT, age TEXT, untreated_decay TEXT, treatment_urgency TEXT, early_childhood_caries TEXT, image TEXT," +
                    "user_id TEXT)",
                    []
                )
                    .then(res => console.log("create result", res))
                    .catch(e => console.log("create DB query error: ", e));
            })
            .catch(e => console.log("OPEN DB Query", e));
    }

    uploadOnlyData() {
        const Data = new FormData;
        Data.append('user_id', this.user_id + "");
        Data.append('gender', this.gender);
        Data.append('race', this.race);
        Data.append('oral_hygiene', this.Hygiene);
        Data.append('treated_decay', this.treated);
        Data.append('presence', this.sealants);
        Data.append('history_rampant_caries', this.history);
        Data.append('spot_lesions', this.white_spot);
        Data.append('age', this.age);
        Data.append('untreated_decay', this.untreated);
        Data.append('treatment_urgency', this.treatment);
        Data.append('early_childhood_caries', this.childhood);
        Data.append('screening_date', this.screenDate);
        Data.append('school_name', this.school_name);
        Data.append('screener_name', this.screener_name);
        Data.append('image', this.imageData)


        this.util.presentLoading();
        this.userAuth.insertData(Data).then((result) => {
            console.log(result);
            this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                this.util.presentToast(result['message']);
            } else {
                this.util.presentToast(result['message']);
            }
        });
    }

}
