import {Component, ViewChild} from "@angular/core";
import {Content, NavController, NavParams} from 'ionic-angular';
import {SQLite, SQLiteObject} from '@ionic-native/sqlite';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from '@ionic/storage';
import {UtilProvider} from '../../providers/util/util';
import {FileTransfer, FileTransferObject, FileUploadOptions} from '@ionic-native/file-transfer';
import {Network} from '@ionic-native/network';

@Component({
    selector: 'page-list',
    templateUrl: 'list.html'
})
export class ListPage {
    @ViewChild('pageTop') pageTop: Content;
    selectedItem: any;
    data: any = [];
    offine_data: any = [];
    user_id: any;
    page: number = 1;
    is_next_page = true;
    ishown = true;

    constructor(public navCtrl: NavController, public navParams: NavParams, public sqlite: SQLite,
                public userAuth: UserauthProvider, public storage: Storage, public util: UtilProvider,
                private transfer: FileTransfer, private network: Network) {

        storage.get('user_id').then(value => {
            this.user_id = value;
            this.select_offline_item(this.user_id);
            if (this.network.type == 'none') {
                this.util.presentCustomToast('Currently you are offline!');
            } else {
                this.getData(this.user_id);
            }
        });

    }

    itemTapped(item) {
        // That's right, we're pushing to ourselves!
        this.navCtrl.push("DetailPage", {
            item: item
        });
    }

    getData(user_id) {
        const Data = new FormData;
        Data.append('user_id', user_id);
        Data.append('page', this.page + "");

        this.util.presentLoading();
        this.userAuth.getListData(Data).then((result) => {
            console.log('List Response', result);
            this.util.dismissLoading();
            this.is_next_page = result['is_next_page'];

            console.log(result['data'].length);
            for (let i = 0; i < result['data'].length; i++) {
                this.data.push(result['data'][i]);
            }
            this.page++;
        });
    }

    sync(item, index) {
        console.log('selected item', item);
        if (item.image) {
            let imagepath = item.image;
            const fileTransfer: FileTransferObject = this.transfer.create();

            let options: FileUploadOptions = {
                fileKey: 'image',
                chunkedMode: false,
                mimeType: 'multipart/form-data',
                headers: {},
                params: {
                    'user_id': item.user_id,
                    'gender': item.gender,
                    'race': item.race,
                    'oral_hygiene': item.oral_hygiene,
                    'treated_decay': item.treated_decay,
                    'presence': item.presence,
                    'history_rampant_caries': item.history_rampant_caries,
                    'spot_lesions': item.spot_lesions,
                    'age': item.age,
                    'untreated_decay': item.untreated_decay,
                    'treatment_urgency': item.treatment_urgency,
                    'early_childhood_caries': item.early_childhood_caries,
                    'screening_date': item.screening_date,
                    'school_name': item.school_name,
                    'screener_name': item.screener_name
                }
            }
            fileTransfer.upload(imagepath, 'http://git.instaacoders.com/api/add_data.php', options)
                .then((data) => {
                    let response: any = JSON.parse(data.response);
                    // save response in storage
                    if (response.success) this.delete_offline_item(item.id);
                    if (this.offine_data.length - 1 == index) {
                        this.util.dismissLoading();
                        this.select_offline_item(this.user_id);
                        setTimeout(() => {
                            this.getData(this.user_id);
                        }, 300);
                        this.util.presentToast(response.message);
                    }
                    console.log('response', response);
                }, (err) => {
                    console.log(err);
                    this.util.dismissLoading();
                });
        } else {
            const Data = new FormData;
            Data.append('user_id', item.user_id + "");
            Data.append('id', item.id + "");
            Data.append('gender', item.gender);
            Data.append('race', item.race);
            Data.append('oral_hygiene', item.Hygiene);
            Data.append('treated_decay', item.treated);
            Data.append('presence', item.sealants);
            Data.append('history_rampant_caries', item.history);
            Data.append('spot_lesions', item.white_spot);
            Data.append('age', item.age);
            Data.append('untreated_decay', item.untreated);
            Data.append('treatment_urgency', item.treatment);
            Data.append('early_childhood_caries', item.childhood);
            Data.append('screening_date', item.screenDate);
            Data.append('school_name', item.school_name);
            Data.append('screener_name', item.screener_name);
            //Data.append('image', this.imageData)
            this.userAuth.insertData(Data).then((result) => {
                console.log(result);

                if (result['success']) {
                    //Display sucess Toast
                    this.delete_offline_item(item.id);
                    if (this.offine_data.length - 1 == index) {

                        this.select_offline_item(this.user_id);
                        setTimeout(() => {
                            this.getData(this.user_id);
                        }, 300);
                        this.util.dismissLoading();
                    }
                }
            });
        }

    }

    syncoffline(item, index) {
        console.log('selected item', item);

        this.delete_offline_item(item.id);

    }

    upload_offline_data() {
        if (this.network.type == 'none') {
            this.util.presentCustomToast('Currently you are offline!');

            // for(let i=0;i< this.offine_data.length;i++){
            //     this.syncoffline(this.offine_data[i], i);
            // }
        } else {
            this.util.presentLoading();
            for (let i = 0; i < this.offine_data.length; i++) {
                this.sync(this.offine_data[i], i);
            }
        }
    }

    select_offline_item(id) {
        this.sqlite.create({
            name: 'datadb.db',
            location: 'default'
        }).then((db: SQLiteObject) => {
            db.executeSql('SELECT * FROM screendata where user_id="' + id + '"', [])
                .then(res => {
                    console.log('Total records', res.rows.length + res.rows.item);
                    this.offine_data = [];
                    for (var i = 0; i < res.rows.length; i++) {
                        console.log(res.rows.item(i));
                        this.offine_data.push(res.rows.item(i));
                    }
                })
                .catch(e => console.log('Error in fetch query', e))
        });
    }

    delete_offline_item(id) {

        this.sqlite.create({
            name: 'datadb.db',
            location: 'default'
        }).then((db: SQLiteObject) => {
            db.executeSql('DELETE FROM screendata WHERE id=?', [id])
                .then(res => {
                    console.log(res);
                    this.util.presentCustomToast('Data deleted succesfully!');

                })
                .catch(e => console.log(e));
        }).catch(e => console.log(e));
    }

    doInfinite(infiniteScroll) {
        console.log('Begin async operation');
        const Data = new FormData;
        Data.append('user_id', this.user_id);
        Data.append('page', this.page + "");

        if (this.network.type == 'none') {
            this.util.presentCustomToast('Currently you are offline!');
        } else {

            this.userAuth.getListData(Data).then((result) => {
                console.log('List Response', result);
                this.is_next_page = result['is_next_page'];

                console.log(result['data'].length);
                for (let i = 0; i < result['data'].length; i++) {
                    console.log(result['data'][i]);
                    this.data.push(result['data'][i]);
                }
                this.page++;
                infiniteScroll.complete();
                this.ishown = false;
            });
        }
    }

    public pageScroller() {
        //scroll to page top
        this.pageTop.scrollToTop();
        this.ishown = true;
    }
}
