import {Component} from '@angular/core';
import {IonicPage, MenuController, NavController, NavParams, Platform} from 'ionic-angular';
import {FingerprintAIO, FingerprintOptions} from '@ionic-native/fingerprint-aio';
import {HomePage} from '../home/home';
import {UtilProvider} from '../../providers/util/util';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from '@ionic/storage';

/**
 * Generated class for the LoginFingerPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-login-finger',
    templateUrl: 'login-finger.html'
})
export class LoginFingerPage {
    fingerprintOptions: FingerprintOptions

    constructor(public navCtrl: NavController,
                public navParams: NavParams,
                public menu: MenuController,
                public util: UtilProvider,
                public userAuth: UserauthProvider,
                public storage: Storage,
                private faio: FingerprintAIO,
                public platform: Platform) {
        this.login();
    }


    ionViewDidLoad() {
        console.log('ionViewDidLoad LoginFingerPage');
    }

    login() {
        this.fingerprintOptions = {
            clientId: 'fingerprint-Demo',
            clientSecret: 'password', //Only necessary for Android
            disableBackup: false, //Only for Android(optional).
            localizedFallbackTitle: ''

        }
        this.faio.isAvailable().then(result => {
            if (result === "finger") {
                this.faio.show(this.fingerprintOptions)
                    .then((result: any) => {
                        if (result.withFingerprint) {
                            console.log('Successfully encrypted credentials.');
                            console.log('Encrypted credentials: ' + result.withFingerprint);
                            this.util.presentToast('Fingerprint register');
                            this.navCtrl.setRoot(HomePage);
                        } else if (result.withPassword) {
                            console.log('Successfully authenticated with backup password!');
                            this.navCtrl.setRoot(HomePage);
                        } else {
                            console.log('Didn\'t authenticate!');
                            this.util.presentToast('Fingerprint unautherised');
                        }
                    })
                    .catch((error: any) => {
                        if (error.message == 'Cancelled') {
                            this.util.presentToast(error.message);
                            this.platform.exitApp();
                        } else {
                            this.util.presentToast(error.message);
                            this.platform.exitApp();
                        }
                    })
            } else {
                debugger;
            }
        })
            .catch((error: any) => {
                if (error.message == 'Fingerprint authentication not ready') {
                    this.util.presentToast(error.message);
                    this.navCtrl.setRoot(HomePage);
                } else {
                    this.util.presentToast(error.message);
                    this.navCtrl.setRoot(HomePage);
                }
            })

    }
}
