import {Component} from '@angular/core';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {UtilProvider} from '../../providers/util/util';
import {RegistrationPage} from '../register/register';
import {ShowquestionsPage} from '../showquestions/showquestions';
import {FingerprintOptions} from '@ionic-native/fingerprint-aio';
import {ShowuseransPage} from '../showuserans/showuserans';
import {UserdeavtivePage} from '../userdeavtive/userdeavtive';
import {Facebook, FacebookLoginResponse} from '@ionic-native/facebook';
import {UploadKYCDocPage} from '../uploadkycdoc/uploadkycdoc';
import {SocialLogin} from '../../providers/userauth/social-login';
import {ViewprofilePage} from '../viewprofile/viewprofile';
import {OtpverificationPage} from '../otpverification/otpverification';

/** 
 * Generated class for the LoginPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
@IonicPage()
@Component({
    selector: 'page-login',
    templateUrl: 'login.html'
})
export class LoginPage {

    isValid: boolean = false;
    email: string;
    password: string;
    isLoggedIn: boolean = false;
    users: any;
    uname: any;
    uemail: any;
    fingerprintOptions: FingerprintOptions;
    msg: string;


    constructor(private fb: Facebook, public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public util: UtilProvider, public menu: MenuController, private socialLogin: SocialLogin) {
    }

    ionViewDidLoad() {
        console.log('ionViewDidLoad LoginPage');
        this.menu.enable(false);
    }

    onSelectChange(selectedValue: any) {
        this.isValid = !!this.email && !!this.password;
    }

    /**
     * Log in user with entered email & password.
     */
    loginWithEmailAndPassword() {
        const loginData = new FormData;
        loginData.append('email', this.email);
        loginData.append('password', this.password);

        this.util.presentLoading();
        this.userAuth.loginUser(loginData).then((result: any) => {
            this.util.dismissLoading();
            if (result['success']) {
                // Display success Toast
                this.util.presentToast(result['message']);

                //Add values in storage
                this.userAuth.handleLoginSuccess(result.user_id);
                // this.storage.store(this.storage.KEY_LOGIN_ID, result['id']);
                // this.storage.store(this.storage.KEY_LOGIN_TYPE, result['type']);
                if(result['otpStatus']=='0'){
                    this.navCtrl.setRoot(OtpverificationPage);
                    return false;
                }
                
                this.menu.enable(true);
                this.userAuth.getUserAns(result['user_id']).then((result) => {
                    if (result[2] != "") {
                        //this.navCtrl.push(ShowuseransPage);
                        this.navCtrl.setRoot(ShowuseransPage);
                    } else {
                        this.navCtrl.setRoot(ShowquestionsPage);
                    }

                });

                //Redirect to dashboard

            } else if (result['lgn'] == 0) {
                this.navCtrl.setRoot(UserdeavtivePage);
            } else {
                this.util.presentToast(result['message']);
            }
        });
        this.util.dismissLoading();
    }

    // public showFingerprintModal() {
    //   this.fingerprintOptions = {
    //       clientId: 'fingerprint-Demo',
    //       clientSecret: 'password', //Only necessary for Android
    //       disableBackup:true  //Only for Android(optional)
    //   }
    //   this.faio.isAvailable().then(result =>{
    //   if(result === "finger")
    //   {
    //       this.faio.show(this.fingerprintOptions)
    //       .then((result: any) => this.navCtrl.setRoot(HomePage)
    //       )
    //       .catch((error: any) => console.log(error));
    //   }
    //   });
    // }

    goToRegisterPage() {
        this.navCtrl.setRoot(RegistrationPage);
    }

    loginWithFacebook() {
        // Login with permissions
        this.fb.login(['public_profile', 'email'])
            .then((res: FacebookLoginResponse) => {

                // The connection was successful
                if (res.status == "connected") {
                    this.isLoggedIn = true;
                    this.getUserDetail(res.authResponse.userID);
                    // Get user ID and Token
                    //var fb_id = res.authResponse.userID;
                    //var fb_token = res.authResponse.accessToken;
                } else {
                    // An error occurred while logging-in
                    console.log("An error occurred...");
                }

            })
            .catch((e) => {
                console.log('Error logging into Facebook', e);
            });
    }

    /**
     * Initiate login with Apple.
     */
    async loginWithApple() {
        let appleData: any;

        try {
            appleData = await this.socialLogin.cordovaAppleSignIn();
        } catch (e) {
            if (e.code === '1001' || e.code === '1003') {
                this.util.presentToast('You cancelled the sign-in');
            } else {
                this.util.presentToast('Unable to process your sign-in with subscription');
            }

            return;
        }

        const data = {
            email: appleData.email,
            name: appleData.name,
            authorizationCode: appleData.authorizationCode
        };

        const promise = this.userAuth.loginWithApple(data);
        this.util.showLoadingFor(promise);

        let apiData: any;

        try {
            apiData = await promise;
        } catch (e) {
            this.util.presentToast('Unable to log you in.');
            return;
        }

        if (apiData.success && apiData.ltype == '0' || apiData.ltype == '1') {
            //Display success Toast
            this.menu.enable(true);
            this.util.presentToast(apiData['message']);
            this.userAuth.handleLoginSuccess(apiData.userId);
            this.navCtrl.setRoot(ViewprofilePage, {isfb: "1"});

            if (apiData.success && apiData.ltype == '0' || apiData.ltype == '1') {
                //Display sucess Toast
                this.menu.enable(true);
                this.util.presentToast(apiData['message']);
                this.userAuth.handleLoginSuccess(apiData.userId);
                this.navCtrl.setRoot(UploadKYCDocPage, {isapple: "1"});
            } else if (apiData.success && apiData.ans == '0') {
                this.userAuth.handleLoginSuccess(apiData.userId);
                this.util.presentToast(apiData['message']);
                this.navCtrl.setRoot(ShowquestionsPage);
            } else if (apiData.success && apiData.ans == '1') {
                this.menu.enable(true);
                this.userAuth.handleLoginSuccess(apiData.userId);
                this.util.presentToast(apiData['message']);
                this.navCtrl.setRoot(ShowuseransPage);
            } else if (apiData['lgn'] == 0) {
                this.navCtrl.setRoot(UserdeavtivePage);
            } else {
                this.util.presentToast(apiData['message']);
            }

        } else {
            this.util.presentToast(apiData['message']);
        }
    }

    private getUserDetail(userid) {
        this.fb.api("/" + userid + "/?fields=id,email,name,picture", ["public_profile"])
            .then(res => {
                console.log(res);
                this.users = res;
                this.uname = res.name;
                this.uemail = res.email;
                this.userAuth.fblogin(this.uname, this.uemail).then((result: any) => {
                    //console.log(result);
                    this.util.dismissLoading();
                    if (result['success'] && result['ltype'] == '0' || result['ltype'] == '1') {
                        //Display sucess Toast
                        this.menu.enable(true);
                        this.util.presentToast(result['message']);
                        this.userAuth.handleLoginSuccess(result.userId);
                        this.navCtrl.setRoot(UploadKYCDocPage, {isfb: "1"});
                    } else if (result['success'] && result['ans'] == '0') {
                        this.userAuth.handleLoginSuccess(result.userId);
                        this.util.presentToast(result['message']);
                        this.navCtrl.setRoot(ShowquestionsPage);
                    } else if (result['success'] && result['ans'] == '1') {
                        this.menu.enable(true);
                        this.userAuth.handleLoginSuccess(result.userId);
                        this.util.presentToast(result['message']);
                        this.navCtrl.setRoot(ShowuseransPage);
                    } else if (result['lgn'] == 0) {
                        this.navCtrl.setRoot(UserdeavtivePage);
                    } else {
                        this.util.presentToast(result['message']);
                    }
                });
            })
            .catch(e => {
                console.log(e);
            });
    }
}
