import {Component} from '@angular/core';
import {FileLikeObject, FileUploader} from 'ng2-file-upload';
import {concat} from 'rxjs';
import {IonicPage} from 'ionic-angular';
import {UserauthProvider} from '../../providers/userauth/userauth';

/**
 * Generated class for the MfilePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
@IonicPage()
@Component({
    selector: 'page-mfile',
    templateUrl: 'mfile.html'
})
export class MfilePage {
    public fileUploader: FileUploader = new FileUploader({});
    public hasBaseDropZoneOver: boolean = false;
    regiData = new FormData;

    constructor(
        public userAuth: UserauthProvider
    ) {
    }

    ionViewDidLoad() {
        console.log('ionViewDidLoad MfilePage');
    }


    fileOverBase(event): void {
        this.hasBaseDropZoneOver = event;
    }

    getFiles(): FileLikeObject[] {
        return this.fileUploader.queue.map((fileItem) => {
            return fileItem.file;

        });
    }

    uploadFiles() {

        let files = this.getFiles();
        let requests = [];
        this.regiData.set('doc[]', '');
        files.forEach((file) => {
            this.regiData.append('doc[]', file.rawFile, file.name);
            //console.log(this.regiData);
        });
        requests.push(this.userAuth.uploadKycimg(this.regiData, 1));


        concat(...requests).subscribe(
            (res) => {
                console.log(res);
            },
            (err) => {
                console.log(err);
            }
        );
    }


}
