import {Component} from "@angular/core";
import {MenuController, NavController, NavParams} from "ionic-angular";
import {Camera, CameraOptions} from "@ionic-native/camera";
import {SQLite, SQLiteObject} from "@ionic-native/sqlite";
import {UtilProvider} from "../../providers/util/util";
import {UserauthProvider} from "../../providers/userauth/userauth";
import {FileTransfer, FileTransferObject, FileUploadOptions} from "@ionic-native/file-transfer";
import {Network} from "@ionic-native/network";
import {ListPage} from "../list/list";

//import { ListPage } from "../list/list";


@Component({
    selector: "page-next",
    templateUrl: "next.html"
})
export class NextPage {
    user_id: number;
    id: number;
    screenDate: any;
    school_name: any;
    screener_name: any;
    gender: any;
    race: any;
    Hygiene: any;
    Hygiene1: any;
    treated: any = [];
    sealants: any;
    history: any;
    white_spot: any;
    untreated: any;
    treatment: any;
    childhood: any;
    age: any;
    imageData: any;
    selectedItem: any;

    data_treated: any = [];

    constructor(
        public navCtrl: NavController,
        public navParams: NavParams,
        private camera: Camera,
        public menu: MenuController,
        private transfer: FileTransfer,
        public sqlite: SQLite,
        public util: UtilProvider,
        public userAuth: UserauthProvider,
        private network: Network
    ) {

        this.selectedItem = navParams.get('item');
        console.log('selected item', this.selectedItem);
        // this.screenDate=this.selectedItem.screening_date;
        // this.school_name=this.selectedItem.school_name;
        // this.screener_name=this.selectedItem.screener_name;

        this.selectedItem = this.navParams.get('item');
        //console.log('selected item', this.selectedItem);
        this.id = this.selectedItem.id;
        this.user_id = this.selectedItem.user_id;
        this.screenDate = this.selectedItem.screening_date;
        this.school_name = this.selectedItem.school_name;
        this.screener_name = this.selectedItem.screener_name;
        this.gender = this.selectedItem.gender;
        this.race = this.selectedItem.race;
        this.Hygiene = this.selectedItem.oral_hygiene;
        this.treated = this.selectedItem.treated_decay;
        this.treated = this.treated.split(",");
        console.log(this.treated);

        this.data_treated = [{name: 'None', checked: this.isInData('None')},
            {name: 'Primary Only', checked: this.isInData('Primary Only')},
            {name: 'Primary and Permanent', checked: this.isInData('Primary and Permanent')},
            {name: 'Permanent Only', checked: this.isInData('Permanent Only')}
        ];


        this.sealants = this.selectedItem.presence;
        this.history = this.selectedItem.history_rampant_caries;
        this.white_spot = this.selectedItem.spot_lesions;
        this.age = this.selectedItem.age;
        this.untreated = this.selectedItem.untreated_decay;
        this.treatment = this.selectedItem.treatment_urgency;
        this.childhood = this.selectedItem.early_childhood_caries;
        this.imageData = this.selectedItem.image;

    }

    selectMember(data) {
        if (data.checked == true) {
            this.treated.push(data.name);
        } else {
            var idx = this.treated.indexOf(data.name);
            this.treated.splice(idx, 1);
        }
        console.log(this.treated);
    }

    ionViewDidEnter() {
        // this.selectedItem = this.navParams.get('item');
        // console.log('selected item', this.selectedItem);
        // this.screenDate=this.selectedItem.screening_date;
        // this.school_name=this.selectedItem.school_name;
        // this.screener_name=this.selectedItem.screener_name;
        // this.gender=this.selectedItem.gender;
        // this.race=this.selectedItem.race;
        // this.Hygiene=this.selectedItem.oral_hygiene;
        // this.treated=this.selectedItem.treated_decay;
        // this.sealants=this.selectedItem.presence;
        // this.history=this.selectedItem.history_rampant_caries;
        // this.white_spot=this.selectedItem.spot_lesions;
        // this.age=this.selectedItem.age;
        // this.untreated=this.selectedItem.untreated_decay;
        // this.treatment=this.selectedItem.treatment_urgency;
        // this.childhood=this.selectedItem.early_childhood_caries;


        //this.util.presentCustomToast("Untreated="+this.Hygiene);

    }

    //takePicture() {
    //  CameraPreview.takePicture({ maxWidth: 320, maxHeight: 320 });

    //}
    takePicture() {
        const options: CameraOptions = {
            quality: 100,
            destinationType: this.camera.DestinationType.FILE_URI,
            encodingType: this.camera.EncodingType.JPEG,
            mediaType: this.camera.MediaType.PICTURE
        };

        this.camera.getPicture(options).then(
            imageData => {
                console.log("imageData : ", imageData);
                this.imageData = imageData;
            },
            err => {
                // Handle error
                console.log("Camera image error", err);
            }
        );
    }

    saveData() {
        console.log("treated", this.treated);
        let treat_urgency = "";
        for (let i = 0; i < this.treated.length; i++) {
            treat_urgency += this.treated[i];
            if (i < this.treated.length - 1) treat_urgency += ",";
        }
        this.treated = treat_urgency;
        console.log("treated", this.treated);

        console.log("network connection type: ", this.network.type);
        console.log("image Data", this.imageData);
        console.log("Hygiene= " + this.Hygiene + "-" +
            this.sealants +
            "-" +
            this.history +
            "-" +
            this.white_spot +
            "-" +
            this.untreated +
            "-" +
            this.treatment +
            "-" +
            this.childhood);
        if (this.screenDate === "" || this.screenDate === "undefined") {
            this.util.presentCustomToast("Please select Screen Date");
        } else if (this.school_name === "" || this.school_name === "undefined") {
            this.util.presentCustomToast("Please Enter School Name");
        } else if (
            this.screener_name === "" ||
            this.screener_name === "undefined"
        ) {
            this.util.presentCustomToast("Please Enter Screener Name");
        } else if (this.gender === "" || this.gender === "undefined") {
            this.util.presentCustomToast("Please select your gender");
        } else if (this.race === "" || this.race === "undefined") {
            this.util.presentCustomToast("Please select your Race/Ethnicity.");
        } else if (this.Hygiene === "" || this.Hygiene === "undefined") {
            this.util.presentCustomToast("Please select your Oral Hygiene.");
        } else if (this.treated === "" || this.treated === "undefined") {
            this.util.presentCustomToast("Please select your Treated Decay.");
        } else if (this.sealants === "" || this.sealants === "undefined") {
            this.util.presentCustomToast(
                "Please select your Presence of Dental Sealants."
            );
        } else if (this.history === "" || this.history === "undefined") {
            this.util.presentCustomToast(
                "Please select your History of Rampant Caries?."
            );
        } else if (this.white_spot === "" || this.white_spot === "undefined") {
            this.util.presentCustomToast("Please select your White Spot Lesions?.");
        } else if (this.age === "" || this.age === "undefined") {
            this.util.presentCustomToast("Please select proper age.");
        } else if (this.untreated === "" || this.untreated === "undefined") {
            this.util.presentCustomToast("Please select Untreated Decay.");
        } else if (this.treatment === "" || this.treatment === "undefined") {
            this.util.presentCustomToast("Please select Treatment Urgency.");
        } else if (this.childhood === "" || this.childhood === "undefined") {
            this.util.presentCustomToast("Please select Early Childhood Caries?.");
        } else {
            if (this.network.type == "none")
                //this.save_data_offile();
                this.util.presentCustomToast("Network error, Could not update the data.");
            else this.uploadData();
        }
    }

    logChosen() {
        console.log('fsdfdf');
    }

    isInData(value) {
        console.log(this.treated.indexOf(value) > -1);
        return this.treated.indexOf(value) > -1;
    }

    uploadData() {
        console.log('Image data: ', this.imageData);
        if (this.imageData) {
            let imagepath = this.imageData;
            this.util.presentLoading();
            //Update Image Data
            this.sqlite.create({
                name: 'datadb.db',
                location: 'default'
            }).then((db: SQLiteObject) => {
                db.executeSql('UPDATE screendata SET image = "' + this.imageData + '" where user_id="' + this.user_id + '"', [])
                    .then(res => {
                        console.log('Offline data updated');

                    })
                    .catch(e => console.log('Error in fetch query', e))
            });
            //
            const fileTransfer: FileTransferObject = this.transfer.create();

            let options: FileUploadOptions = {
                fileKey: "image",
                chunkedMode: false,
                mimeType: "multipart/form-data",
                headers: {},
                params: {
                    id: this.id,
                    user_id: this.user_id,
                    gender: this.gender,
                    race: this.race,
                    oral_hygiene: this.Hygiene,
                    treated_decay: this.treated,
                    presence: this.sealants,
                    history_rampant_caries: this.history,
                    spot_lesions: this.white_spot,
                    age: this.age,
                    untreated_decay: this.untreated,
                    treatment_urgency: this.treatment,
                    early_childhood_caries: this.childhood,
                    screening_date: this.screenDate,
                    school_name: this.school_name,
                    screener_name: this.screener_name,
                    image: this.imageData
                }
            };
            fileTransfer
                .upload(
                    imagepath,
                    "http://git.instaacoders.com/api/edit_data.php",
                    options
                )
                .then(
                    data => {
                        let response: any = JSON.parse(data.response);
                        // save response in storage
                        this.util.dismissLoading();
                        this.util.presentToast(response.message);
                        console.log("response", response);
                        this.navCtrl.setRoot(ListPage);
                    },
                    err => {
                        console.log(err);
                    }
                );
        } else {
            this.uploadOnlyData();
        }
    }

    uploadOnlyData() {
        const Data = new FormData;
        Data.append('user_id', this.user_id + "");
        Data.append('id', this.id + "");
        Data.append('gender', this.gender);
        Data.append('race', this.race);
        Data.append('oral_hygiene', this.Hygiene);
        Data.append('treated_decay', this.treated);
        Data.append('presence', this.sealants);
        Data.append('history_rampant_caries', this.history);
        Data.append('spot_lesions', this.white_spot);
        Data.append('age', this.age);
        Data.append('untreated_decay', this.untreated);
        Data.append('treatment_urgency', this.treatment);
        Data.append('early_childhood_caries', this.childhood);
        Data.append('screening_date', this.screenDate);
        Data.append('school_name', this.school_name);
        Data.append('screener_name', this.screener_name);
        //Data.append('image', this.imageData)


        this.util.presentLoading();
        this.userAuth.editData(Data).then((result) => {
            console.log(result);
            this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                this.util.presentToast(result['message']);
            } else {
                this.util.presentToast(result['message']);
            }
        });
    }

    ionViewDidLoad() {
        console.log("ionViewDidLoad NextPage");
    }
}
