import { Component } from '@angular/core';
import { IonicPage, NavController, NavParams } from 'ionic-angular';
import { UserauthProvider } from '../../providers/userauth/userauth';
import { UtilProvider } from '../../providers/util/util';
import {LoginPage} from '../login/login';
import { Storage } from '@ionic/storage';
import { AlertController } from 'ionic-angular';

/**
 * Generated class for the OtpverificationPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({ 
  selector: 'page-otpverification',
  templateUrl: 'otpverification.html',
})
export class OtpverificationPage {
  public otp : any;
  userId:any;
  title:any;
  subtitle:any;
  editData:any;
  constructor(public navCtrl: NavController,
    public navParams: NavParams,
    public util: UtilProvider,
    public userAuth: UserauthProvider,
    public storage: Storage,
    public alertCtrl: AlertController) {
  }

  ionViewDidLoad() {
    this.storage.get("dataEdit").then(value => {
      this.editData = value;
      if(this.editData == 1){
        this.userAuth.getUpdatemsg().then((result) => {
          console.log(result);
          if (result['success']) {
            this.storage.set('dataEdit', 0);
             this.title = result['title'];
             this.subtitle = result['subtitle'];
          } 
        });

      }else{
        this.userAuth.getRegistermsg().then((result) => {
          console.log(result);
          if (result['success']) {
             this.title = result['title'];
             this.subtitle = result['subtitle'];
          } 
        });
      }
      
    })

  }

  verifyOtp(){
    this.storage.get("user_id").then(value => {
      this.userId = value;
      console.log(this.otp);
      this.util.presentLoading(); 
      this.userAuth.verfyOtp(this.userId,this.otp).then((result) => {
      console.log(result);
      this.util.dismissLoading();
      if (result['success']) {
           this.showAlert();
      } else {
        this.util.presentToast(result['message']);
      }
    });
    })
    
  }

  resendOtp(){
    this.storage.get("user_id").then(value => {
      this.userId = value;
      console.log(this.userId);
      this.util.presentLoading(); 
       this.userAuth.sendOtp(this.userId).then((result) => {
      console.log(result);
      this.util.dismissLoading();
      if (result['success']) {
        this.util.presentToast(result['message']);
      } else {
        this.util.presentToast(result['message']);
      }
    });

    });

  }

  showAlert() {
    const alert = this.alertCtrl.create({
      title: this.title,
      subTitle: this.subtitle,
      buttons: [{
        text: 'Ok',
        handler: () => {
          // user has clicked the alert button
          // begin the alert's dismiss transition
          let navTransition = alert.dismiss();
          this.navCtrl.setRoot(LoginPage);
          return false;
        }
      }]

      
    });
    alert.present();
  }


}
