import {Component} from '@angular/core';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {UtilProvider} from '../../providers/util/util';
import {Storage} from '@ionic/storage';
import {LoginPage} from '../login/login';
import {UploadKYCDocPage} from '../uploadkycdoc/uploadkycdoc';
import {FingerprintOptions} from '@ionic-native/fingerprint-aio';

@IonicPage()
@Component({
    selector: "page-registration",
    templateUrl: "register.html"
})
export class RegistrationPage {

    isValid: boolean = false;
    email: string;
    password: string;
    name: string;
    country: string;
    phoneno: string;
    doc: any[];
    doctype: string;
    countryData: any[];
    fingerprintOptions: FingerprintOptions;
    regiData = new FormData;

    constructor(
        public navCtrl: NavController, public navParams: NavParams, public menu: MenuController, public util: UtilProvider,
        public userAuth: UserauthProvider, public storage: Storage) {
    }

    ionViewDidLoad() {
        console.log('ionViewDidLoad RegistrationPage');

        this.userAuth.getCountry().then((result) => {
            //console.log(result);
            this.countryData = Array.from(result['data']);
            console.log(this.countryData.length);
            this.util.dismissLoading();
            if (result['success']) {

            }
        });
    }

    onSelectChange(selectedValue: any) {
        this.isValid = !!this.email && !!this.password && !!this.name && !!this.country && !!this.phoneno;
    }

    login() {
        this.navCtrl.setRoot(LoginPage);
    }

    // public showFingerprintModal() {
    //   this.fingerprintOptions = {
    //     clientId: 'fingerprint-Demo',
    //     clientSecret: 'password', //Only necessary for Android
    //     disableBackup: false  //Only for Android(optional)
    //   }
    //   this.faio.isAvailable().then(result => {
    //     if (result === "finger") {
    //       this.faio.show(this.fingerprintOptions)
    //         .then((result: any) => {
    //           if (result.withFingerprint) {
    //             console.log('Successfully encrypted credentials.');
    //             console.log('Encrypted credentials: ' + result.withFingerprint);
    //             this.util.presentToast('Fingerprint register');
    //           } else if (result.withBackup) {
    //             console.log('Successfully authenticated with backup password!');
    //           } else console.log('Didn\'t authenticate!');
    //         })
    //         .catch((error: any) => console.log(error));
    //     }
    //   });

    // }

    upload(event) {
        this.regiData.set('doc[]', '');
        let files = event.target.files
        console.log(files);
        Array.from(files).forEach(function (file) {
            this.regiData.append('doc[]', file);
        }.bind(this));
    }

    registration() {
        //console.log(this.regiData.get('doc'));
        this.regiData.append('user_name', this.name);
        this.regiData.append('user_id', this.email);
        this.regiData.append('phone_no', this.phoneno);
        this.regiData.append('password', this.password);
        this.regiData.append('country', this.country);
        this.regiData.append('doctype', this.doctype);

        this.util.presentLoading();
        this.userAuth.regiUser(this.regiData).then((result) => {
            console.log(result);
            this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                //this.util.presentToast(result['message']);
                //this.navCtrl.setRoot(LoginPage);
                this.storage.set('user_id', result['userId']);
                this.navCtrl.setRoot(UploadKYCDocPage);
            } else {
                this.util.presentToast(result['message']);
            }
        });
    }
}
