import {Component} from '@angular/core';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from "@ionic/storage";
import {UtilProvider} from '../../providers/util/util';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {ShowuseransPage} from '../showuserans/showuserans';

/**
 * Generated class for the ShowquestionsPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-showquestions',
    templateUrl: 'showquestions.html'
})
export class ShowquestionsPage {
    msg: string;
    ans: any;
    quesId: any;
    user_id: any;

    constructor(public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public menu: MenuController, private storage: Storage, public util: UtilProvider) {
    }

    ionViewDidLoad() {
        this.menu.enable(true);
        this.userAuth.getQues().then(res => {
            this.quesId = res['data'][0]['id'];
            this.msg = res['data'][0]['ques'];
        })

        this.storage.get("user_id").then(value => {
            this.user_id = value;
        });


    }

    saveVote() {
        const ansData = new FormData;
        ansData.append('qid', this.quesId);
        ansData.append('uid', this.user_id);
        ansData.append('ans', this.ans);

        this.util.presentLoading();
        this.userAuth.insertAns(ansData).then((result) => {
            //console.log(result);
            this.util.dismissLoading();
            if (result['success']) {
                //Display sucess Toast
                this.util.presentToast(result['message']);
                this.navCtrl.setRoot(ShowuseransPage);
            } else {
                this.util.presentToast(result['message']);
            }
        });


    }


}
