import {Component} from '@angular/core';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from "@ionic/storage";
import {UtilProvider} from '../../providers/util/util';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';

/**
 * Generated class for the ShowuseransPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-showuserans',
    templateUrl: 'showuserans.html'
})
export class ShowuseransPage {
    user_id: any;
    ques: string;
    ans: any;
    yesans: any;
    noans: any;

    constructor(public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public menu: MenuController, private storage: Storage, public util: UtilProvider) {
    }

    ionViewDidLoad() {
        this.menu.enable(true);
        this.storage.get("user_id").then(value => {
            this.user_id = value;
            this.userAuth.getUserAns(this.user_id).then((result) => {
                //console.log('yes show me ans');
                // console.log(result);
                this.ques = result[2]['ques'];
                this.ans = result[2]['ans'];
                this.yesans = result[0]['yes'];
                this.noans = result[1]['noans'];
            });

        });

    }

}
