import {Component} from '@angular/core';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {UtilProvider} from '../../providers/util/util';
import {Storage} from '@ionic/storage';
import {LoginPage} from '../login/login';
import {ShowquestionsPage} from '../showquestions/showquestions';
import {OtpverificationPage} from '../otpverification/otpverification';
import {FileLikeObject, FileUploader} from 'ng2-file-upload';

/**
 * Generated class for the UploadkycdocPage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */
@IonicPage()
@Component({
    selector: 'page-uploadkycdoc',
    templateUrl: 'uploadkycdoc.html'
})
export class UploadKYCDocPage {

    readonly MAX_FILES = 10;

    regiData = new FormData();
    userId: any;
    fbdata: any;

    fileUploader: FileUploader = new FileUploader({
        filters: [{
            name: 'maxAllowedFilesFilter',
            fn: this.maxFileSizeFilter.bind(this)
        }]
    });

    constructor(
        public navCtrl: NavController, public navParams: NavParams, public menu: MenuController, public util: UtilProvider,
        public userAuth: UserauthProvider, public storage: Storage) {
    }

    ionViewDidLoad() {
        this.fbdata = this.navParams.get('isfb');
    }

    // upload(event) {
    //   this.regiData.set('doc[]','');
    //   let files = event.target.files
    //   console.log(files);
    //   Array.from(files).forEach(function(file) {
    //     this.regiData.append('doc[]', file);
    //    }.bind(this));
    // }


    // uploadFiles() {

    //   let files = this.getFiles();
    //   let requests = [];
    //   this.regiData.set('doc[]','');
    //   files.forEach((file) => {
    //     this.regiData.append('doc[]' , file.rawFile, file.name);
    //     //console.log(this.regiData);
    //   });
    //   requests.push(this.userAuth.uploadKycimg(this.regiData,1));
    // }

    uploadKYCImages() {
        this.storage.get("user_id").then(value => {
            this.userId = value;
            this.util.presentLoading();

            let files = this.getFiles();
            let requests = [];
            this.regiData.set('doc[]', '');
            files.forEach((file) => {
                this.regiData.append('doc[]', file.rawFile, file.name);
            });

            requests.push(this.userAuth.uploadKycimg(this.regiData, this.userId).then((result) => {
                this.util.dismissLoading();
                if (result['success']) {
                    this.userAuth.sendOtp(this.userId).then((result: any) => {
                        if(result['success']){
                            this.navCtrl.setRoot(OtpverificationPage);
                        }
                    });
                   
                } else {
                    this.util.presentToast(result['message']);
                }

            }));

        });
    }

    maxFileSizeFilter(item?: FileLikeObject): boolean {
        return this.fileUploader.queue.length < this.MAX_FILES;
    }

    getFiles(): FileLikeObject[] {
        return this.fileUploader.queue.map((fileItem) => {
            return fileItem.file;
        });
    }
}
