import {Component} from '@angular/core';
import {UserauthProvider} from '../../providers/userauth/userauth';
import {Storage} from "@ionic/storage";
import {UtilProvider} from '../../providers/util/util';
import {IonicPage, MenuController, NavController, NavParams} from 'ionic-angular';
import {EditprofilePage} from '../editprofile/editprofile';
import {EditdocsPage} from '../editdocs/editdocs';

/**
 * Generated class for the ViewprofilePage page.
 *
 * See https://ionicframework.com/docs/components/#navigation for more info on
 * Ionic pages and navigation.
 */

@IonicPage()
@Component({
    selector: 'page-viewprofile',
    templateUrl: 'viewprofile.html'
})
export class ViewprofilePage {
    user_id: any;
    uname: string;
    uid: any;
    dob: any;
    docs: any[];
    doctype: any;
    phone: any;
    country: any;
    ucity: string;
    uimage: any;
    ustate: any;
    imgIds: any[];
    result2: any[];
    editprofile:any;

    constructor(public navCtrl: NavController, public navParams: NavParams, public userAuth: UserauthProvider,
                public menu: MenuController, private storage: Storage, public util: UtilProvider) {

    }

    ionViewDidLoad() {
        this.storage.get("user_id").then(value => {
            this.user_id = value;
            console.log(this.user_id + 'view profile');
            this.util.presentLoading();
            this.userAuth.viewProfile(this.user_id).then((result) => {
                this.util.dismissLoading();
                // console.log(result);
                this.uid = result['data'][0]['uid'];
                this.uname = result['data'][0]['uname'];
                this.dob = result['data'][0]['dob'];
                this.docs = result['data'][1]['kyc_img'];
                this.imgIds = result['data'][1]['imgid'];
                this.doctype = result['data'][0]['doctype'];
                this.phone = result['data'][0]['phone'];
                this.country = result['data'][0]['country'];
                this.editprofile = result['data'][0]['editProfile'];
                this.ucity = result['data'][0]['ucity'];
                this.uimage = result['data'][0]['uimage'];
                this.ustate = result['data'][0]['ustate'];
                // console.log('yes loaded');
                //console.log(result['data']);
                var ar1 = this.docs;
                var ar2 = this.imgIds;
                var ar3 = [];
                for (let i = 0; i < ar1.length; i++) {
                    ar3.push({"id": ar2[i], "url": ar1[i]})
                }
                this.result2 = Array.from(ar3);
            });

        });

    }

    editProfile() {
        this.navCtrl.setRoot(EditprofilePage);
    }

    editDocs(imgid) {
        console.log(imgid);
        this.navCtrl.push(EditdocsPage, {imgId: imgid});
    }


}
