import {Injectable, NgZone} from '@angular/core';
import { JwtHelperService } from "@auth0/angular-jwt";

declare var cordova: any;

@Injectable()
export class SocialLogin {
    private readonly NAME_SCOPE = 0;
    private readonly EMAIL_SCOPE = 1;
    private jwtHelper = new JwtHelperService();

    constructor(private ngZone: NgZone) {
    }

    /**
     * Wrapping Cordova plugin to be used in Ionic/Angular.
     */
    cordovaAppleSignIn(): Promise<any> {
        const options = {requestedScopes: [this.NAME_SCOPE, this.EMAIL_SCOPE]};

        return new Promise((resolve, reject) => {
            cordova.plugins.SignInWithApple.signin(options, (data: any) => {
                console.log(JSON.stringify(data));

                // "Sign in with Apple" gives the email only first time
                if (!data.email) {
                    // So decode the AWT token and extract the email from it
                    const decodedToken = this.jwtHelper.decodeToken(data.identityToken);
                    data.email = decodedToken.email;
                }

                resolve(data);
            }, (err) => {
                console.log(JSON.stringify(err));
                this.ngZone.run(() => {
                    reject(err);
                });
            })
        });
    }
}
