import {HttpClient} from '@angular/common/http';
import {Injectable} from '@angular/core';
import {Headers, RequestOptions} from '@angular/http';
import {Storage} from '@ionic/storage';

/*
  Generated class for the UserauthProvider provider.

  See https://angular.io/guide/dependency-injection for more info on providers
  and Angular DI.
*/
@Injectable() 
export class UserauthProvider {
    apiUrl = 'https://git.instaacoders.com/api/';
    options: any;

    constructor(public http: HttpClient, private storage: Storage) {
        // console.log('Hello UserauthProvider Provider');
        const headers = new Headers();
        headers.append('Access-Control-Allow-Origin', '*');
        headers.append('Access-Control-Allow-Methods', 'POST, GET, OPTIONS, PUT');
        headers.append('Accept', 'application/json');

        this.options = new RequestOptions({headers: headers, withCredentials: true});
    }

    handleLoginSuccess(userID: string) {
        this.storage.set('isLogin', true);
        this.storage.set('user_id', userID);
    }

    loginUser(data) {
        return this.http.post(this.apiUrl + 'login.php', data).toPromise();
    }

    regiUser(data) {
        return this.http.post(this.apiUrl + 'reg_user.php', data).toPromise();
    }

    insertData(data) {
        return this.http.post(this.apiUrl + 'add_data.php', data).toPromise();
    }

    insertAns(data) {
        return this.http.post(this.apiUrl + 'set_ans.php', data).toPromise();
    }

    getQues() {
        return this.http.get(this.apiUrl + 'get_ques.php').toPromise();
    }

    getUserAns($userId) {
        return this.http.get(this.apiUrl + 'get_user_ans.php?user_id=' + $userId).toPromise();
    }

    viewProfile($userId) {
        return this.http.get(this.apiUrl + 'view-profile.php?user_id=' + $userId).toPromise();
    }

    editProfile($userId) {
        return this.http.get(this.apiUrl + 'edit-profile.php?user_id=' + $userId).toPromise();
    }

    uploadKycimg($data, $userId) {
        //console.log('get user profile');
        //console.log($userId);
        return this.http.post(this.apiUrl + 'upload_kyc_image.php?user_id=' + $userId, $data).toPromise();
    }

    updateDoc($data, $userId, $imageId) {
        return this.http.post(this.apiUrl + 'update_kyc_image.php?user_id=' + $userId + '&img_id=' + $imageId, $data).toPromise();
    }


    updateProfile($data) {
        return this.http.post(this.apiUrl + 'update-profile.php', $data).toPromise();
    }

    getListData(data) {
        return this.http.post(this.apiUrl + 'data_info.php', data).toPromise();
    }

    // new edit data added
    editData(data) {
        return this.http.post(this.apiUrl + 'edit_data.php', data).toPromise();
    }

    getCountry() {
        return this.http.get(this.apiUrl + 'get_countries.php').toPromise();
    }

    fblogin(name, email) {
        return this.http.get(this.apiUrl + 'fb_login.php?name=' + name + '&email=' + email).toPromise();
    }

    loginWithApple(data: AppleSignInData): Promise<any> {
        return this.http.post(this.apiUrl + 'apple_login.php', data).toPromise();
    }

    verfyOtp(email,otp){
        return new Promise((resolve, reject) => {
          this.http.get(this.apiUrl + 'verify-otp.php?user_id='+email+'&otp='+otp)
            .subscribe(res => {
              resolve(res);
            }, (err) => {
              reject(err);
            });
        });
      }
      
      sendOtp(user_id){
        return new Promise((resolve, reject) => {
          this.http.get(this.apiUrl + 'send-otp.php?user_id='+user_id)
            .subscribe(res => {
              resolve(res);
            }, (err) => {
              reject(err);
            });
        });
      }
      
      getRegistermsg(){
        return new Promise((resolve, reject) => {
            this.http.get(this.apiUrl + 'register-message.php')
              .subscribe(res => {
                resolve(res);
              }, (err) => {
                reject(err);
              });
          });
      }

      getUpdatemsg(){
        return new Promise((resolve, reject) => {
            this.http.get(this.apiUrl + 'update-message.php')
              .subscribe(res => {
                resolve(res);
              }, (err) => {
                reject(err);
              });
          });
      }


}

interface AppleSignInData {
    email: string;
    name: string;
    authorizationCode: string;
}
