import {Injectable} from '@angular/core';
import {Loading, LoadingController, ToastController} from 'ionic-angular';

/*
  Generated class for the UtilProvider provider.

  See https://angular.io/guide/dependency-injection for more info on providers
  and Angular DI.
*/
@Injectable()
export class UtilProvider {
    loading: Loading;

    constructor(private loadingCtrl: LoadingController, private toastCtrl: ToastController) {
        console.log('Hello UtilProvider Provider');
    }

    /**
     * Show the spinner/loading until this promise is completed.
     * @param promise
     */
    async showLoadingFor(promise: Promise<any>) {
        await this.presentLoading();

        promise.then(() => {
            this.dismissLoading();
        }, () => {
            this.dismissLoading();
        })
    }

    async presentLoading() {
        this.loading = this.loadingCtrl.create({
            spinner: 'bubbles',
            content: 'Please wait...'
        });

        this.loading.onDidDismiss(() => {
            console.log('Dismissed loading');
        });

        await this.loading.present();
    }

    async dismissLoading() {
        if (this.loading) {
            this.loading.dismiss();
            delete this.loading;
        }
    }

    presentToast(message) {
        const toast = this.toastCtrl.create({
            message: message,
            duration: 2000
        });
        toast.present();
    }

    presentCustomToast(message) {
        const toast = this.toastCtrl.create({
            message: message,
            duration: 2000,
            position: 'bottom',
            cssClass: 'dark-trans',
            closeButtonText: 'OK',
            showCloseButton: true
        });
        toast.present();
    }

    presentErrorToast(message) {
        const toast = this.toastCtrl.create({
            message: message,
            duration: 2000,
            position: 'bottom',
            cssClass: 'error-toast',
            closeButtonText: 'OK',
            showCloseButton: true
        });
        toast.present();
    }

}
